<?php


class BaseEventEmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventEmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_email';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, inst_ref_id', 'required'),
			array('uni_ref_id, inst_ref_id', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>255),
			array('event_date, content', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_email_id, uni_ref_id, inst_ref_id, event_date, subject, content, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_email_id' => 'Event Email',
			'uni_ref_id' => 'Uni Ref',
			'inst_ref_id' => 'Inst Ref',
			'event_date' => 'Event Date',
			'subject' => 'Subject',
			'content' => 'Content',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_email_id',$this->event_email_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('event_date',$this->event_date,true);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('content',$this->content,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}