<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseFranchiseInfo is autogenerate by UniModel generator
 *
 * This is the model class for table "franchise_info".
 *
 * The followings are the available columns in table 'franchise_info':
 * @property integer $franchise_info_id
 * @property string $login_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property integer $city_ref_id
 * @property string $phone_num
 * @property integer $manager
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $manager0
 * @property TblCityMaster $cityRef
 * @property LoginMaster $loginRef
 * @property SchoolFranchise[] $schoolFranchises
 */
class BaseFranchiseInfo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FranchiseInfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'franchise_info';
	}

	/**+560+66666666666666
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('franchise_info_id', 'required'),
			array('city_ref_id, manager', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('first_name, last_name', 'length', 'max'=>100),
			array('phone_num', 'length', 'max'=>50),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('franchise_info_id, login_ref_id, first_name, last_name, city_ref_id, phone_num, manager, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'manager0' => array(self::BELONGS_TO, 'TblAdmin', 'manager'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'schoolFranchises' => array(self::HAS_MANY, 'SchoolFranchise', 'franchise_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'franchise_info_id' => 'Franchise Info',
			'login_ref_id' => 'Login Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'city_ref_id' => 'City Ref',
			'phone_num' => 'Phone Num',
			'manager' => 'Manager',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('franchise_info_id',$this->franchise_info_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('phone_num',$this->phone_num,true);
		$criteria->compare('manager',$this->manager);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}