<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseHostelInfo is autogenerate by UniModel generator
 *
 * This is the model class for table "hostel_info".
 *
 * The followings are the available columns in table 'hostel_info':
 * @property string $hostel_info_id
 * @property integer $uni_ref_id
 * @property integer $uni_course_ref_id
 * @property string $hostel_details
 * @property integer $fees
 * @property integer $currency_ref_id
 * @property string $comments
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupCurrency $currencyRef
 * @property TblAdmin $modifiedBy
 */
class BaseHostelInfo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HostelInfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hostel_info';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id, uni_course_ref_id, fees, currency_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('comments', 'length', 'max'=>255),
			array('hostel_details, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('hostel_info_id, uni_ref_id, uni_course_ref_id, hostel_details, fees, currency_ref_id, comments, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'hostel_info_id' => 'Hostel Info',
			'uni_ref_id' => 'Uni Ref',
			'uni_course_ref_id' => 'Uni Course Ref',
			'hostel_details' => 'Hostel Details',
			'fees' => 'Fees',
			'currency_ref_id' => 'Currency Ref',
			'comments' => 'Comments',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('hostel_info_id',$this->hostel_info_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id);
		$criteria->compare('hostel_details',$this->hostel_details,true);
		$criteria->compare('fees',$this->fees);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('comments',$this->comments,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}