<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLoginMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "login_master".
 *
 * The followings are the available columns in table 'login_master':
 * @property string $login_id
 * @property string $username
 * @property string $pass_word
 * @property integer $user_type_ref_id
 * @property integer $is_active
 * @property integer $is_facebook
 * @property string $last_login
 * @property string $change_password_key
 * @property integer $is_email_confirmed
 * @property integer $is_class_status_confirmed
 * @property integer $is_preference_confirmed
 * @property integer $is_student_profile_confirmed
 * @property integer $student_profile_mail_sent
 * @property string $student_profile_mail_sent_on
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 * @property string $profile_validate_status
 * @property integer $validated_by
 * @property string $is_request_message
 * @property integer $note_added_by
 * @property string $note_added_on
 * @property integer $umail_request_to
 * @property string $request_validated_on
 * @property string $new_umail
 * @property string $is_umail_update
 * @property string $is_valid
 * @property integer $requested_by
 * @property string $validated_on
 *
 * The followings are the available model relations:
 * @property CareerPage[] $careerPages
 * @property CareerPage[] $careerPages1
 * @property CareerVideo[] $careerVideos
 * @property CareerVideo[] $careerVideos1
 * @property CounselorSuggestedEntranceExam[] $counselorSuggestedEntranceExams
 * @property CounselorSuggestedEntranceExam[] $counselorSuggestedEntranceExams1
 * @property CourseAffiliation[] $courseAffiliations
 * @property CourseAffiliation[] $courseAffiliations1
 * @property CourseApplicationDates[] $courseApplicationDates
 * @property CourseApplicationDates[] $courseApplicationDates1
 * @property CourseEligibility[] $courseEligibilities
 * @property CourseEligibility[] $courseEligibilities1
 * @property CourseFees[] $courseFees
 * @property CourseFees[] $courseFees1
 * @property CoursePlacementCompany[] $coursePlacementCompanies
 * @property CoursePlacementCompany[] $coursePlacementCompanies1
 * @property CoursePlacementTopCompany[] $coursePlacementTopCompanies
 * @property CoursePlacementTopCompany[] $coursePlacementTopCompanies1
 * @property CoursePlacementType[] $coursePlacementTypes
 * @property CoursePlacementType[] $coursePlacementTypes1
 * @property CourseStartDate[] $courseStartDates
 * @property CourseStartDate[] $courseStartDates1
 * @property CourseTwining[] $courseTwinings
 * @property CourseTwining[] $courseTwinings1
 * @property CriteriaEducation[] $criteriaEducations
 * @property CriteriaLocation[] $criteriaLocations
 * @property CriteriaPreferredCountry[] $criteriaPreferredCountries
 * @property CriteriaPreferredDepartment[] $criteriaPreferredDepartments
 * @property CriteriaPreferredSchool[] $criteriaPreferredSchools
 * @property DeleteCopyUniversityDateLabel[] $deleteCopyUniversityDateLabels
 * @property DeleteCopyUniversityDateLabel[] $deleteCopyUniversityDateLabels1
 * @property DeleteCopyUniversityDateSection[] $deleteCopyUniversityDateSections
 * @property DeleteCopyUniversityDateSection[] $deleteCopyUniversityDateSections1
 * @property Di[] $dis
 * @property Di[] $dis1
 * @property DiBuyFollowupEmail[] $diBuyFollowupEmails
 * @property DiCashCredit[] $diCashCredits
 * @property DiCashCredit[] $diCashCredits1
 * @property DiCashDebit[] $diCashDebits
 * @property DiProduct[] $diProducts
 * @property DiProduct[] $diProducts1
 * @property DiProductCredit[] $diProductCredits
 * @property DiProductCredit[] $diProductCredits1
 * @property DiProductDebit[] $diProductDebits
 * @property DiSignup[] $diSignups
 * @property DiUser[] $diUsers
 * @property DiUser[] $diUsers1
 * @property DiUser[] $diUsers2
 * @property DiUserCounsellorShortlist[] $diUserCounsellorShortlists
 * @property DiUserCounsellorShortlist[] $diUserCounsellorShortlists1
 * @property DiUserCounsellorSuggested[] $diUserCounsellorSuggesteds
 * @property DiUserCriteriaDuration[] $diUserCriteriaDurations
 * @property DiUserCriteriaDuration[] $diUserCriteriaDurations1
 * @property DiUserCriteriaEntranceExam[] $diUserCriteriaEntranceExams
 * @property DiUserCriteriaEntranceExam[] $diUserCriteriaEntranceExams1
 * @property DiUserCriteriaGrade[] $diUserCriteriaGrades
 * @property DiUserCriteriaGrade[] $diUserCriteriaGrades1
 * @property DiUserCriteriaLikelyPeriod[] $diUserCriteriaLikelyPeriods
 * @property DiUserCriteriaLikelyPeriod[] $diUserCriteriaLikelyPeriods1
 * @property DiUserCriteriaShortlist[] $diUserCriteriaShortlists
 * @property DiUserCriteriaShortlist[] $diUserCriteriaShortlists1
 * @property DiUserDepartment[] $diUserDepartments
 * @property DiUserDepartment[] $diUserDepartments1
 * @property DiUserEoi[] $diUserEois
 * @property DiUserEoi[] $diUserEois1
 * @property DiUserEoiLog[] $diUserEoiLogs
 * @property DiUserEoiLogAttachment[] $diUserEoiLogAttachments
 * @property DiUserEoiMessage[] $diUserEoiMessages
 * @property DiUserEoiScholarship[] $diUserEoiScholarships
 * @property DiUserEoiScholarship[] $diUserEoiScholarships1
 * @property DiUserEoiScholarshipLog[] $diUserEoiScholarshipLogs
 * @property DiUserRefund[] $diUserRefunds
 * @property EmailerMilestoneTracker[] $emailerMilestoneTrackers
 * @property EntranceExam[] $entranceExams
 * @property EntranceExam[] $entranceExams1
 * @property EntranceExamApplicableDepartment[] $entranceExamApplicableDepartments
 * @property EntranceExamApplicableDepartment[] $entranceExamApplicableDepartments1
 * @property EntranceExamApplicableLocation[] $entranceExamApplicableLocations
 * @property EntranceExamApplicableLocation[] $entranceExamApplicableLocations1
 * @property EntranceExamCourseLevel[] $entranceExamCourseLevels
 * @property EntranceExamCourseLevel[] $entranceExamCourseLevels1
 * @property EntranceExamDate[] $entranceExamDates
 * @property EntranceExamDate[] $entranceExamDates1
 * @property EntranceExamDateLabel[] $entranceExamDateLabels
 * @property EntranceExamDateLabel[] $entranceExamDateLabels1
 * @property EntranceExamDateSection[] $entranceExamDateSections
 * @property EntranceExamDateSection[] $entranceExamDateSections1
 * @property EntranceExamFees[] $entranceExamFees
 * @property EntranceExamFees[] $entranceExamFees1
 * @property EntranceExamMode[] $entranceExamModes
 * @property EntranceExamMode[] $entranceExamModes1
 * @property EntranceExamPreparation[] $entranceExamPreparations
 * @property EntranceExamPreparation[] $entranceExamPreparations1
 * @property EntranceExamSamplePaper[] $entranceExamSamplePapers
 * @property EntranceExamSamplePaper[] $entranceExamSamplePapers1
 * @property Event[] $events
 * @property Event[] $events1
 * @property EventInvitation[] $eventInvitations
 * @property EventSpeaker[] $eventSpeakers
 * @property FbMaster[] $fbMasters
 * @property GemLeadProspect[] $gemLeadProspects
 * @property GemLeadProspect[] $gemLeadProspects1
 * @property HostelInfo[] $hostelInfos
 * @property HostelInfo[] $hostelInfos1
 * @property IconFavourites[] $iconFavourites
 * @property InvoiceCustomerProduct[] $invoiceCustomerProducts
 * @property InvoiceCustomerProduct[] $invoiceCustomerProducts1
 * @property LoginLog[] $loginLogs
 * @property TblAdmin $requestedBy
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 * @property TblAdmin $noteAddedBy
 * @property LookupUserType $userTypeRef
 * @property TblAdmin $umailRequestTo
 * @property TblAdmin $validatedBy
 * @property MdmCourseLog[] $mdmCourseLogs
 * @property MdmCourseLog[] $mdmCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property MdmNewCourseLog[] $mdmNewCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs2
 * @property OrderMaster[] $orderMasters
 * @property PmsStudentBucket[] $pmsStudentBuckets
 * @property PmsUniversityBucket[] $pmsUniversityBuckets
 * @property PmsUniversityContact[] $pmsUniversityContacts
 * @property PmsUniversityContactNumber[] $pmsUniversityContactNumbers
 * @property RecentUsed[] $recentUseds
 * @property Scholarship[] $scholarships
 * @property Scholarship[] $scholarships1
 * @property ScholarshipAge[] $scholarshipAges
 * @property ScholarshipContact[] $scholarshipContacts
 * @property ScholarshipContact[] $scholarshipContacts1
 * @property ScholarshipDepartment[] $scholarshipDepartments
 * @property ScholarshipDepartment[] $scholarshipDepartments1
 * @property ScholarshipDestinationCountry[] $scholarshipDestinationCountries
 * @property ScholarshipEligibilityClass[] $scholarshipEligibilityClasses
 * @property ScholarshipEligibilityClass[] $scholarshipEligibilityClasses1
 * @property ScholarshipEligibilityEntrance[] $scholarshipEligibilityEntrances
 * @property ScholarshipEligibilityEntrance[] $scholarshipEligibilityEntrances1
 * @property ScholarshipFinancialNeed[] $scholarshipFinancialNeeds
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes1
 * @property ScholarshipTarget[] $scholarshipTargets
 * @property ScholarshipTarget[] $scholarshipTargets1
 * @property SiMilestoneDate[] $siMilestoneDates
 * @property SiMilestoneDate[] $siMilestoneDates1
 * @property SiMilestoneNotes[] $siMilestoneNotes
 * @property SiMilestoneNotes[] $siMilestoneNotes1
 * @property SiMilestoneReminder[] $siMilestoneReminders
 * @property SiMilestoneReminder[] $siMilestoneReminders1
 * @property SiTrackMilestone[] $siTrackMilestones
 * @property SiTrackMilestone[] $siTrackMilestones1
 * @property StudentAlternateEmail[] $studentAlternateEmails
 * @property StudentAlternateEmail[] $studentAlternateEmails1
 * @property StudentAlternateEmail[] $studentAlternateEmails2
 * @property StudentAssignedAdvisor[] $studentAssignedAdvisors
 * @property StudentAssignedAdvisor[] $studentAssignedAdvisors1
 * @property StudentContactNumber[] $studentContactNumbers
 * @property StudentContactNumber[] $studentContactNumbers1
 * @property StudentHotlead[] $studentHotleads
 * @property StudentHotlead[] $studentHotleads1
 * @property StudentHypothesisCountry[] $studentHypothesisCountries
 * @property StudentHypothesisDepartment[] $studentHypothesisDepartments
 * @property StudentIdealListCollege[] $studentIdealListColleges
 * @property StudentIdealListCollege[] $studentIdealListColleges1
 * @property StudentIdealListCollegeLog[] $studentIdealListCollegeLogs
 * @property StudentIdealListCollegeLog[] $studentIdealListCollegeLogs1
 * @property StudentMilestoneComment[] $studentMilestoneComments
 * @property StudentProfileValidationLog[] $studentProfileValidationLogs
 * @property StudentShortlistUniversity[] $studentShortlistUniversities
 * @property StudentShortlistUniversity[] $studentShortlistUniversities1
 * @property StudentUploadMasterList[] $studentUploadMasterLists
 * @property StudentUploadMasterList[] $studentUploadMasterLists1
 * @property StudentUploadMasterNoEmail[] $studentUploadMasterNoEmails
 * @property StudentUploadMasterNoEmail[] $studentUploadMasterNoEmails1
 * @property Tag[] $tags
 * @property TagEntranceExam[] $tagEntranceExams
 * @property TagScholarship[] $tagScholarships
 * @property TagUniversity[] $tagUniversities
 * @property TblAdmin[] $tblAdmins
 * @property TblUniCourses[] $tblUniCourses
 * @property TblUniExtension[] $tblUniExtensions
 * @property TblUniExtension[] $tblUniExtensions1
 * @property TblUniPicturesVideos[] $tblUniPicturesVideoses
 * @property TblUniPicturesVideos[] $tblUniPicturesVideoses1
 * @property TblUniSafety[] $tblUniSafeties
 * @property TblUniSafety[] $tblUniSafeties1
 * @property TblUniVisa[] $tblUniVisas
 * @property TblUniVisa[] $tblUniVisas1
 * @property TblUniWeather[] $tblUniWeathers
 * @property TblUniWeather[] $tblUniWeathers1
 * @property TblUniversityMaster[] $tblUniversityMasters
 * @property TblUniversityMaster[] $tblUniversityMasters1
 * @property TblUserMaster[] $tblUserMasters
 * @property TrainingModule[] $trainingModules
 * @property TrainingModuleSlide[] $trainingModuleSlides
 * @property TrainingModuleSlideAssessment[] $trainingModuleSlideAssessments
 * @property TrainingModuleSlideAssessmentAnswer[] $trainingModuleSlideAssessmentAnswers
 * @property TrainingModuleSlideAssessmentQuestion[] $trainingModuleSlideAssessmentQuestions
 * @property TrainingModuleSlidePhotoCaption[] $trainingModuleSlidePhotoCaptions
 * @property TrainingModuleSlideText[] $trainingModuleSlideTexts
 * @property TrainingModuleSlideTitle[] $trainingModuleSlideTitles
 * @property TrainingUserAssessment[] $trainingUserAssessments
 * @property TrainingUserProgress[] $trainingUserProgresses
 * @property UniCourseContact[] $uniCourseContacts
 * @property UniCourseContact[] $uniCourseContacts1
 * @property UniCourseReservation[] $uniCourseReservations
 * @property UniCourseReservation[] $uniCourseReservations1
 * @property UniCourseTest[] $uniCourseTests
 * @property UniCourseTest[] $uniCourseTests1
 * @property UniveristyContact[] $univeristyContacts
 * @property UniveristyContact[] $univeristyContacts1
 * @property UniveristyFinancials[] $univeristyFinancials
 * @property UniveristyFinancials[] $univeristyFinancials1
 * @property UniversityAdditionalInfo[] $universityAdditionalInfos
 * @property UniversityAdditionalInfo[] $universityAdditionalInfos1
 * @property UniversityAlumni[] $universityAlumnis
 * @property UniversityAlumni[] $universityAlumnis1
 * @property UniversityCourseDateDescription[] $universityCourseDateDescriptions
 * @property UniversityCourseDateDescription[] $universityCourseDateDescriptions1
 * @property UniversityDateIntake[] $universityDateIntakes
 * @property UniversityDateIntake[] $universityDateIntakes1
 * @property UniversityDateIntakeDescription[] $universityDateIntakeDescriptions
 * @property UniversityDateIntakeDescription[] $universityDateIntakeDescriptions1
 * @property UniversityDeptRanking[] $universityDeptRankings
 * @property UniversityDeptRanking[] $universityDeptRankings1
 * @property UniversityEthnicity[] $universityEthnicities
 * @property UniversityEthnicity[] $universityEthnicities1
 * @property UniversitySocialMedia[] $universitySocialMedias
 * @property UniversitySocialMedia[] $universitySocialMedias1
 * @property UserAttachment[] $userAttachments
 * @property UserEntranceExam[] $userEntranceExams
 * @property UserEntranceExam[] $userEntranceExams1
 * @property UserEntranceExamModule[] $userEntranceExamModules
 * @property UserEntranceExamModule[] $userEntranceExamModules1
 * @property UserIdealList[] $userIdealLists
 * @property UserIdealList[] $userIdealLists1
 * @property UserIdealListUniversity[] $userIdealListUniversities
 * @property UserIdealListUniversity[] $userIdealListUniversities1
 * @property UserIdealListUniversity[] $userIdealListUniversities2
 * @property UserIdealListUniversityLog[] $userIdealListUniversityLogs
 * @property UserMilestoneSuggestion[] $userMilestoneSuggestions
 * @property UserScholarship[] $userScholarships
 * @property UserUniversitySearch[] $userUniversitySearches
 * @property Vendor[] $vendors
 * @property Vendor[] $vendors1
 * @property VendorCenter[] $vendorCenters
 * @property VendorCenter[] $vendorCenters1
 * @property VendorCenterContact[] $vendorCenterContacts
 * @property VendorCenterContact[] $vendorCenterContacts1
 * @property VendorCenterEmail[] $vendorCenterEmails
 * @property VendorCenterVendorCourse[] $vendorCenterVendorCourses
 * @property VendorCourse[] $vendorCourses
 * @property VendorCourse[] $vendorCourses1
 * @property VendorCourseEntranceExam[] $vendorCourseEntranceExams
 */
class BaseLoginMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LoginMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'login_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, pass_word, user_type_ref_id, is_active, added_on', 'required'),
			array('user_type_ref_id, is_active, is_facebook, is_email_confirmed, is_class_status_confirmed, is_preference_confirmed, is_student_profile_confirmed, student_profile_mail_sent, added_by, modified_by, validated_by, note_added_by, umail_request_to, requested_by', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>100),
			array('pass_word', 'length', 'max'=>255),
			array('change_password_key', 'length', 'max'=>50),
			array('profile_validate_status', 'length', 'max'=>16),
			array('new_umail, is_umail_update, is_valid', 'length', 'max'=>1),
			array('last_login, student_profile_mail_sent_on, modified_on, is_request_message, note_added_on, request_validated_on, validated_on ,is_systempwd', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('login_id, username, pass_word, user_type_ref_id, is_active, is_facebook, last_login, change_password_key, is_email_confirmed, is_class_status_confirmed, is_preference_confirmed, is_student_profile_confirmed, student_profile_mail_sent, student_profile_mail_sent_on, added_on, added_by, modified_on, modified_by, profile_validate_status, validated_by, is_request_message, note_added_by, note_added_on, umail_request_to, request_validated_on, new_umail, is_umail_update, is_valid, requested_by, validated_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'careerPages' => array(self::HAS_MANY, 'CareerPage', 'added_by'),
			'careerPages1' => array(self::HAS_MANY, 'CareerPage', 'modified_by'),
			'careerVideos' => array(self::HAS_MANY, 'CareerVideo', 'added_by'),
			'careerVideos1' => array(self::HAS_MANY, 'CareerVideo', 'modified_by'),
			'counselorSuggestedEntranceExams' => array(self::HAS_MANY, 'CounselorSuggestedEntranceExam', 'added_by'),
			'counselorSuggestedEntranceExams1' => array(self::HAS_MANY, 'CounselorSuggestedEntranceExam', 'modified_by'),
			'courseAffiliations' => array(self::HAS_MANY, 'CourseAffiliation', 'added_by'),
			'courseAffiliations1' => array(self::HAS_MANY, 'CourseAffiliation', 'modified_by'),
			'courseApplicationDates' => array(self::HAS_MANY, 'CourseApplicationDates', 'added_by'),
			'courseApplicationDates1' => array(self::HAS_MANY, 'CourseApplicationDates', 'modified_by'),
			'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'added_by'),
			'courseEligibilities1' => array(self::HAS_MANY, 'CourseEligibility', 'modified_by'),
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'added_by'),
			'courseFees1' => array(self::HAS_MANY, 'CourseFees', 'modified_by'),
			'coursePlacementCompanies' => array(self::HAS_MANY, 'CoursePlacementCompany', 'added_by'),
			'coursePlacementCompanies1' => array(self::HAS_MANY, 'CoursePlacementCompany', 'modified_by'),
			'coursePlacementTopCompanies' => array(self::HAS_MANY, 'CoursePlacementTopCompany', 'added_by'),
			'coursePlacementTopCompanies1' => array(self::HAS_MANY, 'CoursePlacementTopCompany', 'modified_by'),
			'coursePlacementTypes' => array(self::HAS_MANY, 'CoursePlacementType', 'added_by'),
			'coursePlacementTypes1' => array(self::HAS_MANY, 'CoursePlacementType', 'modified_by'),
			'courseStartDates' => array(self::HAS_MANY, 'CourseStartDate', 'added_by'),
			'courseStartDates1' => array(self::HAS_MANY, 'CourseStartDate', 'modified_by'),
			'courseTwinings' => array(self::HAS_MANY, 'CourseTwining', 'added_by'),
			'courseTwinings1' => array(self::HAS_MANY, 'CourseTwining', 'modified_by'),
			'criteriaEducations' => array(self::HAS_MANY, 'CriteriaEducation', 'added_by'),
			'criteriaLocations' => array(self::HAS_MANY, 'CriteriaLocation', 'added_by'),
			'criteriaPreferredCountries' => array(self::HAS_MANY, 'CriteriaPreferredCountry', 'added_by'),
			'criteriaPreferredDepartments' => array(self::HAS_MANY, 'CriteriaPreferredDepartment', 'added_by'),
			'criteriaPreferredSchools' => array(self::HAS_MANY, 'CriteriaPreferredSchool', 'added_by'),
			'deleteCopyUniversityDateLabels' => array(self::HAS_MANY, 'DeleteCopyUniversityDateLabel', 'added_by'),
			'deleteCopyUniversityDateLabels1' => array(self::HAS_MANY, 'DeleteCopyUniversityDateLabel', 'modified_by'),
			'deleteCopyUniversityDateSections' => array(self::HAS_MANY, 'DeleteCopyUniversityDateSection', 'added_by'),
			'deleteCopyUniversityDateSections1' => array(self::HAS_MANY, 'DeleteCopyUniversityDateSection', 'modified_by'),
			'dis' => array(self::HAS_MANY, 'Di', 'added_by'),
			'dis1' => array(self::HAS_MANY, 'Di', 'modified_by'),
			'diBuyFollowupEmails' => array(self::HAS_MANY, 'DiBuyFollowupEmail', 'added_by'),
			'diCashCredits' => array(self::HAS_MANY, 'DiCashCredit', 'added_by'),
			'diCashCredits1' => array(self::HAS_MANY, 'DiCashCredit', 'modified_by'),
			'diCashDebits' => array(self::HAS_MANY, 'DiCashDebit', 'added_by'),
			'diProducts' => array(self::HAS_MANY, 'DiProduct', 'added_by'),
			'diProducts1' => array(self::HAS_MANY, 'DiProduct', 'modified_by'),
			'diProductCredits' => array(self::HAS_MANY, 'DiProductCredit', 'added_by'),
			'diProductCredits1' => array(self::HAS_MANY, 'DiProductCredit', 'modified_by'),
			'diProductDebits' => array(self::HAS_MANY, 'DiProductDebit', 'added_by'),
			'diSignups' => array(self::HAS_MANY, 'DiSignup', 'login_ref_id'),
			'diUsers' => array(self::HAS_MANY, 'DiUser', 'added_by'),
			'diUsers1' => array(self::HAS_MANY, 'DiUser', 'login_ref_id'),
			'diUsers2' => array(self::HAS_MANY, 'DiUser', 'modified_by'),
			'diUserCounsellorShortlists' => array(self::HAS_MANY, 'DiUserCounsellorShortlist', 'added_by'),
			'diUserCounsellorShortlists1' => array(self::HAS_MANY, 'DiUserCounsellorShortlist', 'modified_by'),
			'diUserCounsellorSuggesteds' => array(self::HAS_MANY, 'DiUserCounsellorSuggested', 'added_by'),
			'diUserCriteriaDurations' => array(self::HAS_MANY, 'DiUserCriteriaDuration', 'added_by'),
			'diUserCriteriaDurations1' => array(self::HAS_MANY, 'DiUserCriteriaDuration', 'modified_by'),
			'diUserCriteriaEntranceExams' => array(self::HAS_MANY, 'DiUserCriteriaEntranceExam', 'added_by'),
			'diUserCriteriaEntranceExams1' => array(self::HAS_MANY, 'DiUserCriteriaEntranceExam', 'modified_by'),
			'diUserCriteriaGrades' => array(self::HAS_MANY, 'DiUserCriteriaGrade', 'added_by'),
			'diUserCriteriaGrades1' => array(self::HAS_MANY, 'DiUserCriteriaGrade', 'modified_by'),
			'diUserCriteriaLikelyPeriods' => array(self::HAS_MANY, 'DiUserCriteriaLikelyPeriod', 'added_by'),
			'diUserCriteriaLikelyPeriods1' => array(self::HAS_MANY, 'DiUserCriteriaLikelyPeriod', 'modified_by'),
			'diUserCriteriaShortlists' => array(self::HAS_MANY, 'DiUserCriteriaShortlist', 'added_by'),
			'diUserCriteriaShortlists1' => array(self::HAS_MANY, 'DiUserCriteriaShortlist', 'modified_by'),
			'diUserDepartments' => array(self::HAS_MANY, 'DiUserDepartment', 'added_by'),
			'diUserDepartments1' => array(self::HAS_MANY, 'DiUserDepartment', 'modified_by'),
			'diUserEois' => array(self::HAS_MANY, 'DiUserEoi', 'added_by'),
			'diUserEois1' => array(self::HAS_MANY, 'DiUserEoi', 'modified_by'),
			'diUserEoiLogs' => array(self::HAS_MANY, 'DiUserEoiLog', 'added_by'),
			'diUserEoiLogAttachments' => array(self::HAS_MANY, 'DiUserEoiLogAttachment', 'added_by'),
			'diUserEoiMessages' => array(self::HAS_MANY, 'DiUserEoiMessage', 'added_by'),
			'diUserEoiScholarships' => array(self::HAS_MANY, 'DiUserEoiScholarship', 'added_by'),
			'diUserEoiScholarships1' => array(self::HAS_MANY, 'DiUserEoiScholarship', 'modified_by'),
			'diUserEoiScholarshipLogs' => array(self::HAS_MANY, 'DiUserEoiScholarshipLog', 'added_by'),
			'diUserRefunds' => array(self::HAS_MANY, 'DiUserRefund', 'added_by'),
			'emailerMilestoneTrackers' => array(self::HAS_MANY, 'EmailerMilestoneTracker', 'login_ref_id'),
			'entranceExams' => array(self::HAS_MANY, 'EntranceExam', 'added_by'),
			'entranceExams1' => array(self::HAS_MANY, 'EntranceExam', 'modified_by'),
			'entranceExamApplicableDepartments' => array(self::HAS_MANY, 'EntranceExamApplicableDepartment', 'added_by'),
			'entranceExamApplicableDepartments1' => array(self::HAS_MANY, 'EntranceExamApplicableDepartment', 'modified_by'),
			'entranceExamApplicableLocations' => array(self::HAS_MANY, 'EntranceExamApplicableLocation', 'added_by'),
			'entranceExamApplicableLocations1' => array(self::HAS_MANY, 'EntranceExamApplicableLocation', 'modified_by'),
			'entranceExamCourseLevels' => array(self::HAS_MANY, 'EntranceExamCourseLevel', 'added_by'),
			'entranceExamCourseLevels1' => array(self::HAS_MANY, 'EntranceExamCourseLevel', 'modified_by'),
			'entranceExamDates' => array(self::HAS_MANY, 'EntranceExamDate', 'added_by'),
			'entranceExamDates1' => array(self::HAS_MANY, 'EntranceExamDate', 'modified_by'),
			'entranceExamDateLabels' => array(self::HAS_MANY, 'EntranceExamDateLabel', 'added_by'),
			'entranceExamDateLabels1' => array(self::HAS_MANY, 'EntranceExamDateLabel', 'modified_by'),
			'entranceExamDateSections' => array(self::HAS_MANY, 'EntranceExamDateSection', 'added_by'),
			'entranceExamDateSections1' => array(self::HAS_MANY, 'EntranceExamDateSection', 'modified_by'),
			'entranceExamFees' => array(self::HAS_MANY, 'EntranceExamFees', 'added_by'),
			'entranceExamFees1' => array(self::HAS_MANY, 'EntranceExamFees', 'modified_by'),
			'entranceExamModes' => array(self::HAS_MANY, 'EntranceExamMode', 'added_by'),
			'entranceExamModes1' => array(self::HAS_MANY, 'EntranceExamMode', 'modified_by'),
			'entranceExamPreparations' => array(self::HAS_MANY, 'EntranceExamPreparation', 'added_by'),
			'entranceExamPreparations1' => array(self::HAS_MANY, 'EntranceExamPreparation', 'modified_by'),
			'entranceExamSamplePapers' => array(self::HAS_MANY, 'EntranceExamSamplePaper', 'added_by'),
			'entranceExamSamplePapers1' => array(self::HAS_MANY, 'EntranceExamSamplePaper', 'modified_by'),
			'events' => array(self::HAS_MANY, 'Event', 'added_by'),
			'events1' => array(self::HAS_MANY, 'Event', 'modified_by'),
			'eventInvitations' => array(self::HAS_MANY, 'EventInvitation', 'added_by'),
			'eventSpeakers' => array(self::HAS_MANY, 'EventSpeaker', 'added_by'),
			'fbMasters' => array(self::HAS_MANY, 'FbMaster', 'login_ref_id'),
			'gemLeadProspects' => array(self::HAS_MANY, 'GemLeadProspect', 'added_by'),
			'gemLeadProspects1' => array(self::HAS_MANY, 'GemLeadProspect', 'modified_by'),
			'hostelInfos' => array(self::HAS_MANY, 'HostelInfo', 'added_by'),
			'hostelInfos1' => array(self::HAS_MANY, 'HostelInfo', 'modified_by'),
			'iconFavourites' => array(self::HAS_MANY, 'IconFavourites', 'login_ref_id'),
			'invoiceCustomerProducts' => array(self::HAS_MANY, 'InvoiceCustomerProduct', 'added_by'),
			'invoiceCustomerProducts1' => array(self::HAS_MANY, 'InvoiceCustomerProduct', 'modified_by'),
			'loginLogs' => array(self::HAS_MANY, 'LoginLog', 'login_ref_id'),
			'requestedBy' => array(self::BELONGS_TO, 'TblAdmin', 'requested_by'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'noteAddedBy' => array(self::BELONGS_TO, 'TblAdmin', 'note_added_by'),
			'userTypeRef' => array(self::BELONGS_TO, 'LookupUserType', 'user_type_ref_id'),
			'umailRequestTo' => array(self::BELONGS_TO, 'TblAdmin', 'umail_request_to'),
			'validatedBy' => array(self::BELONGS_TO, 'TblAdmin', 'validated_by'),
			'mdmCourseLogs' => array(self::HAS_MANY, 'MdmCourseLog', 'approved_by'),
			'mdmCourseLogs1' => array(self::HAS_MANY, 'MdmCourseLog', 'request_by_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'approved_by'),
			'mdmNewCourseLogs1' => array(self::HAS_MANY, 'MdmNewCourseLog', 'modified_by'),
			'mdmNewCourseLogs2' => array(self::HAS_MANY, 'MdmNewCourseLog', 'request_by_id'),
			'orderMasters' => array(self::HAS_MANY, 'OrderMaster', 'login_ref_id'),
			'pmsStudentBuckets' => array(self::HAS_MANY, 'PmsStudentBucket', 'added_by'),
			'pmsUniversityBuckets' => array(self::HAS_MANY, 'PmsUniversityBucket', 'added_by'),
			'pmsUniversityContacts' => array(self::HAS_MANY, 'PmsUniversityContact', 'added_by'),
			'pmsUniversityContactNumbers' => array(self::HAS_MANY, 'PmsUniversityContactNumber', 'added_by'),
			'recentUseds' => array(self::HAS_MANY, 'RecentUsed', 'login_ref_id'),
			'scholarships' => array(self::HAS_MANY, 'Scholarship', 'added_by'),
			'scholarships1' => array(self::HAS_MANY, 'Scholarship', 'modified_by'),
			'scholarshipAges' => array(self::HAS_MANY, 'ScholarshipAge', 'added_by'),
			'scholarshipContacts' => array(self::HAS_MANY, 'ScholarshipContact', 'added_by'),
			'scholarshipContacts1' => array(self::HAS_MANY, 'ScholarshipContact', 'modified_by'),
			'scholarshipDepartments' => array(self::HAS_MANY, 'ScholarshipDepartment', 'added_by'),
			'scholarshipDepartments1' => array(self::HAS_MANY, 'ScholarshipDepartment', 'modified_by'),
			'scholarshipDestinationCountries' => array(self::HAS_MANY, 'ScholarshipDestinationCountry', 'added_by'),
			'scholarshipEligibilityClasses' => array(self::HAS_MANY, 'ScholarshipEligibilityClass', 'added_by'),
			'scholarshipEligibilityClasses1' => array(self::HAS_MANY, 'ScholarshipEligibilityClass', 'modified_by'),
			'scholarshipEligibilityEntrances' => array(self::HAS_MANY, 'ScholarshipEligibilityEntrance', 'added_by'),
			'scholarshipEligibilityEntrances1' => array(self::HAS_MANY, 'ScholarshipEligibilityEntrance', 'modified_by'),
			'scholarshipFinancialNeeds' => array(self::HAS_MANY, 'ScholarshipFinancialNeed', 'added_by'),
			'scholarshipHostInstitutes' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'added_by'),
			'scholarshipHostInstitutes1' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'modified_by'),
			'scholarshipTargets' => array(self::HAS_MANY, 'ScholarshipTarget', 'added_by'),
			'scholarshipTargets1' => array(self::HAS_MANY, 'ScholarshipTarget', 'modified_by'),
			'siMilestoneDates' => array(self::HAS_MANY, 'SiMilestoneDate', 'added_by'),
			'siMilestoneDates1' => array(self::HAS_MANY, 'SiMilestoneDate', 'modified_by'),
			'siMilestoneNotes' => array(self::HAS_MANY, 'SiMilestoneNotes', 'added_by'),
			'siMilestoneNotes1' => array(self::HAS_MANY, 'SiMilestoneNotes', 'modified_by'),
			'siMilestoneReminders' => array(self::HAS_MANY, 'SiMilestoneReminder', 'added_by'),
			'siMilestoneReminders1' => array(self::HAS_MANY, 'SiMilestoneReminder', 'modified_by'),
			'siTrackMilestones' => array(self::HAS_MANY, 'SiTrackMilestone', 'added_by'),
			'siTrackMilestones1' => array(self::HAS_MANY, 'SiTrackMilestone', 'modified_by'),
			'studentAlternateEmails' => array(self::HAS_MANY, 'StudentAlternateEmail', 'login_ref_id'),
			'studentAlternateEmails1' => array(self::HAS_MANY, 'StudentAlternateEmail', 'added_by'),
			'studentAlternateEmails2' => array(self::HAS_MANY, 'StudentAlternateEmail', 'modified_by'),
			'studentAssignedAdvisors' => array(self::HAS_MANY, 'StudentAssignedAdvisor', 'added_by'),
			'studentAssignedAdvisors1' => array(self::HAS_MANY, 'StudentAssignedAdvisor', 'modified_by'),
			'studentContactNumbers' => array(self::HAS_MANY, 'StudentContactNumber', 'added_by'),
			'studentContactNumbers1' => array(self::HAS_MANY, 'StudentContactNumber', 'modified_by'),
			'studentHotleads' => array(self::HAS_MANY, 'StudentHotlead', 'added_by'),
			'studentHotleads1' => array(self::HAS_MANY, 'StudentHotlead', 'modified_by'),
			'studentHypothesisCountries' => array(self::HAS_MANY, 'StudentHypothesisCountry', 'added_by'),
			'studentHypothesisDepartments' => array(self::HAS_MANY, 'StudentHypothesisDepartment', 'added_by'),
			'studentIdealListColleges' => array(self::HAS_MANY, 'StudentIdealListCollege', 'comment_by'),
			'studentIdealListColleges1' => array(self::HAS_MANY, 'StudentIdealListCollege', 'suggested_by'),
			'studentIdealListCollegeLogs' => array(self::HAS_MANY, 'StudentIdealListCollegeLog', 'comment_by'),
			'studentIdealListCollegeLogs1' => array(self::HAS_MANY, 'StudentIdealListCollegeLog', 'suggested_by'),
			'studentMilestoneComments' => array(self::HAS_MANY, 'StudentMilestoneComment', 'added_by'),
			'studentProfileValidationLogs' => array(self::HAS_MANY, 'StudentProfileValidationLog', 'added_by'),
			'studentShortlistUniversities' => array(self::HAS_MANY, 'StudentShortlistUniversity', 'added_by'),
			'studentShortlistUniversities1' => array(self::HAS_MANY, 'StudentShortlistUniversity', 'modified_by'),
			'studentUploadMasterLists' => array(self::HAS_MANY, 'StudentUploadMasterList', 'added_by'),
			'studentUploadMasterLists1' => array(self::HAS_MANY, 'StudentUploadMasterList', 'modified_by'),
			'studentUploadMasterNoEmails' => array(self::HAS_MANY, 'StudentUploadMasterNoEmail', 'added_by'),
			'studentUploadMasterNoEmails1' => array(self::HAS_MANY, 'StudentUploadMasterNoEmail', 'modified_by'),
			'tags' => array(self::HAS_MANY, 'Tag', 'added_by'),
			'tagEntranceExams' => array(self::HAS_MANY, 'TagEntranceExam', 'added_by'),
			'tagScholarships' => array(self::HAS_MANY, 'TagScholarship', 'added_by'),
			'tagUniversities' => array(self::HAS_MANY, 'TagUniversity', 'added_by'),
			'tblAdmins' => array(self::HAS_MANY, 'TblAdmin', 'login_ref_id'),
			'tblUniCourses' => array(self::HAS_MANY, 'TblUniCourses', 'added_by'),
			'tblUniExtensions' => array(self::HAS_MANY, 'TblUniExtension', 'added_by'),
			'tblUniExtensions1' => array(self::HAS_MANY, 'TblUniExtension', 'modified_by'),
			'tblUniPicturesVideoses' => array(self::HAS_MANY, 'TblUniPicturesVideos', 'added_by'),
			'tblUniPicturesVideoses1' => array(self::HAS_MANY, 'TblUniPicturesVideos', 'modified_by'),
			'tblUniSafeties' => array(self::HAS_MANY, 'TblUniSafety', 'added_by'),
			'tblUniSafeties1' => array(self::HAS_MANY, 'TblUniSafety', 'modified_by'),
			'tblUniVisas' => array(self::HAS_MANY, 'TblUniVisa', 'added_by'),
			'tblUniVisas1' => array(self::HAS_MANY, 'TblUniVisa', 'modified_by'),
			'tblUniWeathers' => array(self::HAS_MANY, 'TblUniWeather', 'added_by'),
			'tblUniWeathers1' => array(self::HAS_MANY, 'TblUniWeather', 'modified_by'),
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'added_by'),
			'tblUniversityMasters1' => array(self::HAS_MANY, 'TblUniversityMaster', 'modified_by'),
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'login_ref_id'),
			'trainingModules' => array(self::HAS_MANY, 'TrainingModule', 'added_by'),
			'trainingModuleSlides' => array(self::HAS_MANY, 'TrainingModuleSlide', 'added_by'),
			'trainingModuleSlideAssessments' => array(self::HAS_MANY, 'TrainingModuleSlideAssessment', 'added_by'),
			'trainingModuleSlideAssessmentAnswers' => array(self::HAS_MANY, 'TrainingModuleSlideAssessmentAnswer', 'added_by'),
			'trainingModuleSlideAssessmentQuestions' => array(self::HAS_MANY, 'TrainingModuleSlideAssessmentQuestion', 'added_by'),
			'trainingModuleSlidePhotoCaptions' => array(self::HAS_MANY, 'TrainingModuleSlidePhotoCaption', 'added_by'),
			'trainingModuleSlideTexts' => array(self::HAS_MANY, 'TrainingModuleSlideText', 'added_by'),
			'trainingModuleSlideTitles' => array(self::HAS_MANY, 'TrainingModuleSlideTitle', 'added_by'),
			'trainingUserAssessments' => array(self::HAS_MANY, 'TrainingUserAssessment', 'login_ref_id'),
			'trainingUserProgresses' => array(self::HAS_MANY, 'TrainingUserProgress', 'login_ref_id'),
			'uniCourseContacts' => array(self::HAS_MANY, 'UniCourseContact', 'added_by'),
			'uniCourseContacts1' => array(self::HAS_MANY, 'UniCourseContact', 'modified_by'),
			'uniCourseReservations' => array(self::HAS_MANY, 'UniCourseReservation', 'added_by'),
			'uniCourseReservations1' => array(self::HAS_MANY, 'UniCourseReservation', 'modified_by'),
			'uniCourseTests' => array(self::HAS_MANY, 'UniCourseTest', 'added_by'),
			'uniCourseTests1' => array(self::HAS_MANY, 'UniCourseTest', 'modified_by'),
			'univeristyContacts' => array(self::HAS_MANY, 'UniveristyContact', 'added_by'),
			'univeristyContacts1' => array(self::HAS_MANY, 'UniveristyContact', 'modified_by'),
			'univeristyFinancials' => array(self::HAS_MANY, 'UniveristyFinancials', 'added_by'),
			'univeristyFinancials1' => array(self::HAS_MANY, 'UniveristyFinancials', 'modified_by'),
			'universityAdditionalInfos' => array(self::HAS_MANY, 'UniversityAdditionalInfo', 'added_by'),
			'universityAdditionalInfos1' => array(self::HAS_MANY, 'UniversityAdditionalInfo', 'modified_by'),
			'universityAlumnis' => array(self::HAS_MANY, 'UniversityAlumni', 'added_by'),
			'universityAlumnis1' => array(self::HAS_MANY, 'UniversityAlumni', 'modified_by'),
			'universityCourseDateDescriptions' => array(self::HAS_MANY, 'UniversityCourseDateDescription', 'added_by'),
			'universityCourseDateDescriptions1' => array(self::HAS_MANY, 'UniversityCourseDateDescription', 'modified_by'),
			'universityDateIntakes' => array(self::HAS_MANY, 'UniversityDateIntake', 'added_by'),
			'universityDateIntakes1' => array(self::HAS_MANY, 'UniversityDateIntake', 'modified_by'),
			'universityDateIntakeDescriptions' => array(self::HAS_MANY, 'UniversityDateIntakeDescription', 'added_by'),
			'universityDateIntakeDescriptions1' => array(self::HAS_MANY, 'UniversityDateIntakeDescription', 'modified_by'),
			'universityDeptRankings' => array(self::HAS_MANY, 'UniversityDeptRanking', 'added_by'),
			'universityDeptRankings1' => array(self::HAS_MANY, 'UniversityDeptRanking', 'modified_by'),
			'universityEthnicities' => array(self::HAS_MANY, 'UniversityEthnicity', 'added_by'),
			'universityEthnicities1' => array(self::HAS_MANY, 'UniversityEthnicity', 'modified_by'),
			'universitySocialMedias' => array(self::HAS_MANY, 'UniversitySocialMedia', 'added_by'),
			'universitySocialMedias1' => array(self::HAS_MANY, 'UniversitySocialMedia', 'modified_by'),
			'userAttachments' => array(self::HAS_MANY, 'UserAttachment', 'added_by'),
			'userEntranceExams' => array(self::HAS_MANY, 'UserEntranceExam', 'added_by'),
			'userEntranceExams1' => array(self::HAS_MANY, 'UserEntranceExam', 'modified_by'),
			'userEntranceExamModules' => array(self::HAS_MANY, 'UserEntranceExamModule', 'added_by'),
			'userEntranceExamModules1' => array(self::HAS_MANY, 'UserEntranceExamModule', 'modified_by'),
			'userIdealLists' => array(self::HAS_MANY, 'UserIdealList', 'added_by'),
			'userIdealLists1' => array(self::HAS_MANY, 'UserIdealList', 'modified_by'),
			'userIdealListUniversities' => array(self::HAS_MANY, 'UserIdealListUniversity', 'added_by'),
			'userIdealListUniversities1' => array(self::HAS_MANY, 'UserIdealListUniversity', 'modified_by'),
			'userIdealListUniversities2' => array(self::HAS_MANY, 'UserIdealListUniversity', 'suggested_by_ref_id'),
			'userIdealListUniversityLogs' => array(self::HAS_MANY, 'UserIdealListUniversityLog', 'added_by'),
			'userMilestoneSuggestions' => array(self::HAS_MANY, 'UserMilestoneSuggestion', 'added_by'),
			'userScholarships' => array(self::HAS_MANY, 'UserScholarship', 'added_by'),
			'userUniversitySearches' => array(self::HAS_MANY, 'UserUniversitySearch', 'login_ref_id'),
			'vendors' => array(self::HAS_MANY, 'Vendor', 'added_by'),
			'vendors1' => array(self::HAS_MANY, 'Vendor', 'modified_by'),
			'vendorCenters' => array(self::HAS_MANY, 'VendorCenter', 'added_by'),
			'vendorCenters1' => array(self::HAS_MANY, 'VendorCenter', 'modified_by'),
			'vendorCenterContacts' => array(self::HAS_MANY, 'VendorCenterContact', 'added_by'),
			'vendorCenterContacts1' => array(self::HAS_MANY, 'VendorCenterContact', 'modified_by'),
			'vendorCenterEmails' => array(self::HAS_MANY, 'VendorCenterEmail', 'added_by'),
			'vendorCenterVendorCourses' => array(self::HAS_MANY, 'VendorCenterVendorCourse', 'added_by'),
			'vendorCourses' => array(self::HAS_MANY, 'VendorCourse', 'added_by'),
			'vendorCourses1' => array(self::HAS_MANY, 'VendorCourse', 'modified_by'),
			'vendorCourseEntranceExams' => array(self::HAS_MANY, 'VendorCourseEntranceExam', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'login_id' => 'Login',
			'username' => 'Username',
			'pass_word' => 'Pass Word',
			'user_type_ref_id' => 'User Type Ref',
			'is_active' => 'Is Active',
			'is_facebook' => 'Is Facebook',
			'last_login' => 'Last Login',
			'change_password_key' => 'Change Password Key',
			'is_email_confirmed' => 'Is Email Confirmed',
			'is_class_status_confirmed' => 'Is Class Status Confirmed',
			'is_preference_confirmed' => 'Is Preference Confirmed',
			'is_student_profile_confirmed' => 'Is Student Profile Confirmed',
			'student_profile_mail_sent' => 'Student Profile Mail Sent',
			'student_profile_mail_sent_on' => 'Student Profile Mail Sent On',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'profile_validate_status' => 'Profile Validate Status',
			'validated_by' => 'Validated By',
			'is_request_message' => 'Is Request Message',
			'note_added_by' => 'Note Added By',
			'note_added_on' => 'Note Added On',
			'umail_request_to' => 'Umail Request To',
			'request_validated_on' => 'Request Validated On',
			'new_umail' => 'New Umail',
			'is_umail_update' => 'Is Umail Update',
			'is_valid' => 'Is Valid',
			'requested_by' => 'Requested By',
			'validated_on' => 'Validated On',
			'is_systempwd'=>'is_systempwd',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('login_id',$this->login_id,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('pass_word',$this->pass_word,true);
		$criteria->compare('user_type_ref_id',$this->user_type_ref_id);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('is_facebook',$this->is_facebook);
		$criteria->compare('last_login',$this->last_login,true);
		$criteria->compare('change_password_key',$this->change_password_key,true);
		$criteria->compare('is_email_confirmed',$this->is_email_confirmed);
		$criteria->compare('is_class_status_confirmed',$this->is_class_status_confirmed);
		$criteria->compare('is_preference_confirmed',$this->is_preference_confirmed);
		$criteria->compare('is_student_profile_confirmed',$this->is_student_profile_confirmed);
		$criteria->compare('student_profile_mail_sent',$this->student_profile_mail_sent);
		$criteria->compare('student_profile_mail_sent_on',$this->student_profile_mail_sent_on,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('profile_validate_status',$this->profile_validate_status,true);
		$criteria->compare('validated_by',$this->validated_by);
		$criteria->compare('is_request_message',$this->is_request_message,true);
		$criteria->compare('note_added_by',$this->note_added_by);
		$criteria->compare('note_added_on',$this->note_added_on,true);
		$criteria->compare('umail_request_to',$this->umail_request_to);
		$criteria->compare('request_validated_on',$this->request_validated_on,true);
		$criteria->compare('new_umail',$this->new_umail,true);
		$criteria->compare('is_umail_update',$this->is_umail_update,true);
		$criteria->compare('is_valid',$this->is_valid,true);
		$criteria->compare('requested_by',$this->requested_by);
		$criteria->compare('validated_on',$this->validated_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}