<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupContinent is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_continent".
 *
 * The followings are the available columns in table 'lookup_continent':
 * @property integer $continent_id
 * @property string $continent_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes
 */
class BaseLookupContinent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupContinent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_continent';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('continent_name, added_on', 'required'),
			array('continent_name', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('continent_id, continent_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarshipHostInstitutes' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'continent_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'continent_id' => 'Continent',
			'continent_name' => 'Continent Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('continent_id',$this->continent_id);
		$criteria->compare('continent_name',$this->continent_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}