<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCurrency is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_currency".
 *
 * The followings are the available columns in table 'lookup_currency':
 * @property integer $currency_id
 * @property string $currency_code
 * @property string $currency_name
 * @property string $country_name
 * @property string $currency_icon
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property CourseFees[] $courseFees
 * @property HostelInfo[] $hostelInfos
 * @property MdmNewCourseFees[] $mdmNewCourseFees
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property MdmNewCourseLog[] $mdmNewCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs2
 * @property MdmNewCourseLog[] $mdmNewCourseLogs3
 * @property MdmNewCourseLog[] $mdmNewCourseLogs4
 * @property MdmNewCourseLog[] $mdmNewCourseLogs5
 * @property MdmNewHostelInfo[] $mdmNewHostelInfos
 * @property TblUniCourses[] $tblUniCourses
 * @property TblUniCourses[] $tblUniCourses1
 * @property TblUniCourses[] $tblUniCourses2
 * @property TblUniCourses[] $tblUniCourses3
 * @property TblUniCourses[] $tblUniCourses4
 * @property TblUniCourses[] $tblUniCourses5
 * @property UniCoursePlacement[] $uniCoursePlacements
 * @property UniCoursePlacement[] $uniCoursePlacements1
 * @property UniCoursePlacement[] $uniCoursePlacements2
 * @property UniCoursePlacement[] $uniCoursePlacements3
 * @property UniCoursePlacement[] $uniCoursePlacements4
 * @property UniCoursePlacement[] $uniCoursePlacements5
 */
class BaseLookupCurrency extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCurrency the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_currency';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('currency_code', 'length', 'max'=>10),
			array('currency_name, country_name', 'length', 'max'=>45),
			array('currency_icon', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('currency_id, currency_code, currency_name, country_name, currency_icon, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'currency_ref_id'),
			'hostelInfos' => array(self::HAS_MANY, 'HostelInfo', 'currency_ref_id'),
			'mdmNewCourseFees' => array(self::HAS_MANY, 'MdmNewCourseFees', 'currency_ref_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'avg_salary_currency_ref_id'),
			'mdmNewCourseLogs1' => array(self::HAS_MANY, 'MdmNewCourseLog', 'high_domestic_salary_currency_ref_id'),
			'mdmNewCourseLogs2' => array(self::HAS_MANY, 'MdmNewCourseLog', 'high_international_salary_currency_ref_id'),
			'mdmNewCourseLogs3' => array(self::HAS_MANY, 'MdmNewCourseLog', 'high_sal_range_currency_ref_id'),
			'mdmNewCourseLogs4' => array(self::HAS_MANY, 'MdmNewCourseLog', 'low_sal_range_currency_ref_id'),
			'mdmNewCourseLogs5' => array(self::HAS_MANY, 'MdmNewCourseLog', 'median_salary_currency_ref_id'),
			'mdmNewHostelInfos' => array(self::HAS_MANY, 'MdmNewHostelInfo', 'currency_ref_id'),
			'tblUniCourses' => array(self::HAS_MANY, 'TblUniCourses', 'avg_salary_currency_ref_id'),
			'tblUniCourses1' => array(self::HAS_MANY, 'TblUniCourses', 'high_domestic_salary_currency_ref_id'),
			'tblUniCourses2' => array(self::HAS_MANY, 'TblUniCourses', 'high_international_salary_currency_ref_id'),
			'tblUniCourses3' => array(self::HAS_MANY, 'TblUniCourses', 'high_sal_range_currency_ref_id'),
			'tblUniCourses4' => array(self::HAS_MANY, 'TblUniCourses', 'low_sal_range_currency_ref_id'),
			'tblUniCourses5' => array(self::HAS_MANY, 'TblUniCourses', 'median_salary_currency_ref_id'),
			'uniCoursePlacements' => array(self::HAS_MANY, 'UniCoursePlacement', 'avg_salary_currency_ref_id'),
			'uniCoursePlacements1' => array(self::HAS_MANY, 'UniCoursePlacement', 'highest_domestic_currency_ref_id'),
			'uniCoursePlacements2' => array(self::HAS_MANY, 'UniCoursePlacement', 'highest_international_currency_ref_id'),
			'uniCoursePlacements3' => array(self::HAS_MANY, 'UniCoursePlacement', 'high_salary_currency_ref_id'),
			'uniCoursePlacements4' => array(self::HAS_MANY, 'UniCoursePlacement', 'low_salary_currency_ref_id'),
			'uniCoursePlacements5' => array(self::HAS_MANY, 'UniCoursePlacement', 'median_salary_currency_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'currency_id' => 'Currency',
			'currency_code' => 'Currency Code',
			'currency_name' => 'Currency Name',
			'country_name' => 'Country Name',
			'currency_icon' => 'Currency Icon',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('currency_code',$this->currency_code,true);
		$criteria->compare('currency_name',$this->currency_name,true);
		$criteria->compare('country_name',$this->country_name,true);
		$criteria->compare('currency_icon',$this->currency_icon,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}