<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupGrade is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_grade".
 *
 * The followings are the available columns in table 'lookup_grade':
 * @property integer $grade_id
 * @property string $grade_type
 * @property integer $rank
 *
 * The followings are the available model relations:
 * @property CutoffOverallGrades[] $cutoffOverallGrades
 * @property CutoffSubjectGrades[] $cutoffSubjectGrades
 * @property DiUserCriteriaGrade[] $diUserCriteriaGrades
 * @property StudentGradeCount[] $studentGradeCounts
 */
class BaseLookupGrade extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupGrade the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_grade';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('grade_type, rank', 'required'),
			array('rank', 'numerical', 'integerOnly'=>true),
			array('grade_type', 'length', 'max'=>5),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('grade_id, grade_type, rank', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cutoffOverallGrades' => array(self::HAS_MANY, 'CutoffOverallGrades', 'grade_ref_id'),
			'cutoffSubjectGrades' => array(self::HAS_MANY, 'CutoffSubjectGrades', 'grade_ref_id'),
			'diUserCriteriaGrades' => array(self::HAS_MANY, 'DiUserCriteriaGrade', 'grade_ref_id'),
			'studentGradeCounts' => array(self::HAS_MANY, 'StudentGradeCount', 'grade_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'grade_id' => 'Grade',
			'grade_type' => 'Grade Type',
			'rank' => 'Rank',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('grade_id',$this->grade_id);
		$criteria->compare('grade_type',$this->grade_type,true);
		$criteria->compare('rank',$this->rank);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}