<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupInterest is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_interest".
 *
 * The followings are the available columns in table 'lookup_interest':
 * @property integer $interest_id
 * @property string $interest
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupCareerInterestMapping[] $lookupCareerInterestMappings
 * @property LookupCareerInterestMapping[] $lookupCareerInterestMappings1
 */
class BaseLookupInterest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupInterest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_interest';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('interest, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('interest', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('interest_id, interest, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupCareerInterestMappings' => array(self::HAS_MANY, 'LookupCareerInterestMapping', 'primary_interest_ref_id'),
			'lookupCareerInterestMappings1' => array(self::HAS_MANY, 'LookupCareerInterestMapping', 'secondary_interest_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'interest_id' => 'Interest',
			'interest' => 'Interest',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('interest_id',$this->interest_id);
		$criteria->compare('interest',$this->interest,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}