<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupMockupSubjects is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_mockup_subjects".
 *
 * The followings are the available columns in table 'lookup_mockup_subjects':
 * @property string $subject_id
 * @property string $parent_id
 * @property string $subject_name
 * @property string $seo_title
 * @property string $added_on
 * @property string $modified_on
 */
class BaseLookupMockupSubjects extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupMockupSubjects the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_mockup_subjects';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject_name, seo_title', 'required'),
			array('parent_id', 'length', 'max'=>10),
			array('subject_name, seo_title', 'length', 'max'=>150),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('subject_id, parent_id, subject_name, seo_title, added_on, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'subject_id' => 'Subject',
			'parent_id' => 'Parent',
			'subject_name' => 'Subject Name',
			'seo_title' => 'Seo Title',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('subject_id',$this->subject_id,true);
		$criteria->compare('parent_id',$this->parent_id,true);
		$criteria->compare('subject_name',$this->subject_name,true);
		$criteria->compare('seo_title',$this->seo_title,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}