<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupPrimaryFinancing is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_primary_financing".
 *
 * The followings are the available columns in table 'lookup_primary_financing':
 * @property integer $primary_financing_id
 * @property string $source_name
 * @property integer $is_active
 * @property string $added_on
 */
class BaseLookupPrimaryFinancing extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPrimaryFinancing the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_primary_financing';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('source_name, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('source_name', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('primary_financing_id, source_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'primary_financing_id' => 'Primary Financing',
			'source_name' => 'Source Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('primary_financing_id',$this->primary_financing_id);
		$criteria->compare('source_name',$this->source_name,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}