<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupProfileScoreStatus is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_profile_score_status".
 *
 * The followings are the available columns in table 'lookup_profile_score_status':
 * @property integer $profile_score_status_id
 * @property string $status_name
 * @property string $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property ProfileScoreInteraction[] $profileScoreInteractions
 * @property UserProfileScore[] $userProfileScores
 */
class BaseLookupProfileScoreStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupProfileScoreStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_profile_score_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status_name', 'length', 'max'=>150),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('profile_score_status_id, status_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'profileScoreInteractions' => array(self::HAS_MANY, 'ProfileScoreInteraction', 'user_status'),
			'userProfileScores' => array(self::HAS_MANY, 'UserProfileScore', 'user_current_status'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_score_status_id' => 'Profile Score Status',
			'status_name' => 'Status Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_score_status_id',$this->profile_score_status_id);
		$criteria->compare('status_name',$this->status_name,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}