<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupScholarshipProviderType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_scholarship_provider_type".
 *
 * The followings are the available columns in table 'lookup_scholarship_provider_type':
 * @property integer $scholarship_provider_type_id
 * @property string $provider_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Scholarship[] $scholarships
 */
class BaseLookupScholarshipProviderType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupScholarshipProviderType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_scholarship_provider_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('provider_type, added_on', 'required'),
			array('provider_type', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_provider_type_id, provider_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarships' => array(self::HAS_MANY, 'Scholarship', 'scholarship_provider_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_provider_type_id' => 'Scholarship Provider Type',
			'provider_type' => 'Provider Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_provider_type_id',$this->scholarship_provider_type_id);
		$criteria->compare('provider_type',$this->provider_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}