<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupStandardExam is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_standard_exam".
 *
 * The followings are the available columns in table 'lookup_standard_exam':
 * @property integer $standard_exam_id
 * @property string $exam_name
 * @property integer $plan_option
 * @property string $naming_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiUserAlertStandardExam[] $diUserAlertStandardExams
 * @property StandardExamCompleted[] $standardExamCompleteds
 * @property StandardExamPlanned[] $standardExamPlanneds
 * @property StandardExamValidation[] $standardExamValidations
 */
class BaseLookupStandardExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupStandardExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_standard_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('plan_option', 'numerical', 'integerOnly'=>true),
			array('exam_name', 'length', 'max'=>75),
			array('naming_type', 'length', 'max'=>45),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('standard_exam_id, exam_name, plan_option, naming_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserAlertStandardExams' => array(self::HAS_MANY, 'DiUserAlertStandardExam', 'standard_exam_ref_id'),
			'standardExamCompleteds' => array(self::HAS_MANY, 'StandardExamCompleted', 'standard_exam_ref_id'),
			'standardExamPlanneds' => array(self::HAS_MANY, 'StandardExamPlanned', 'standard_exam_ref_id'),
			'standardExamValidations' => array(self::HAS_MANY, 'StandardExamValidation', 'standard_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'standard_exam_id' => 'Standard Exam',
			'exam_name' => 'Exam Name',
			'plan_option' => 'Plan Option',
			'naming_type' => 'Naming Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('standard_exam_id',$this->standard_exam_id);
		$criteria->compare('exam_name',$this->exam_name,true);
		$criteria->compare('plan_option',$this->plan_option);
		$criteria->compare('naming_type',$this->naming_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}