<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupStandardExamModule is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_standard_exam_module".
 *
 * The followings are the available columns in table 'lookup_standard_exam_module':
 * @property integer $standard_exam_module_id
 * @property string $module_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiUserAlertStandardExam[] $diUserAlertStandardExams
 * @property StandardExamCompleted[] $standardExamCompleteds
 * @property StandardExamValidation[] $standardExamValidations
 */
class BaseLookupStandardExamModule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupStandardExamModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_standard_exam_module';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('module_name', 'length', 'max'=>75),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('standard_exam_module_id, module_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserAlertStandardExams' => array(self::HAS_MANY, 'DiUserAlertStandardExam', 'standard_exam_module_ref_id'),
			'standardExamCompleteds' => array(self::HAS_MANY, 'StandardExamCompleted', 'standard_exam_module_ref_id'),
			'standardExamValidations' => array(self::HAS_MANY, 'StandardExamValidation', 'standard_exam_module_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'standard_exam_module_id' => 'Standard Exam Module',
			'module_name' => 'Module Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('standard_exam_module_id',$this->standard_exam_module_id);
		$criteria->compare('module_name',$this->module_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}