<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupStudentSubject is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_student_subject".
 *
 * The followings are the available columns in table 'lookup_student_subject':
 * @property integer $student_subject_id
 * @property integer $board_ref_id
 * @property string $subject_name
 * @property string $class
 * @property string $subject_master_ref_id
 *
 * The followings are the available model relations:
 * @property CourseEligibility[] $courseEligibilities
 * @property CutoffSubjectGrades[] $cutoffSubjectGrades
 * @property CutoffSubjectMapping[] $cutoffSubjectMappings
 * @property CutoffSubjectMarks[] $cutoffSubjectMarks
 * @property LookupBoardEquivalent $boardRef
 * @property LookupSubjectMaster $subjectMasterRef
 * @property MdmNewCourseEligibility[] $mdmNewCourseEligibilities
 * @property StudentEducationDetail[] $studentEducationDetails
 * @property StudentPreferredSubject[] $studentPreferredSubjects
 */
class BaseLookupStudentSubject extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupStudentSubject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_student_subject';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('board_ref_id', 'numerical', 'integerOnly'=>true),
			array('subject_name', 'length', 'max'=>50),
			array('class', 'length', 'max'=>2),
			array('subject_master_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_subject_id, board_ref_id, subject_name, class, subject_master_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'student_subject_ref_id'),
			'cutoffSubjectGrades' => array(self::HAS_MANY, 'CutoffSubjectGrades', 'subject_ref_id'),
			'cutoffSubjectMappings' => array(self::HAS_MANY, 'CutoffSubjectMapping', 'student_subject_ref_id'),
			'cutoffSubjectMarks' => array(self::HAS_MANY, 'CutoffSubjectMarks', 'subject_ref_id'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoardEquivalent', 'board_ref_id'),
			'subjectMasterRef' => array(self::BELONGS_TO, 'LookupSubjectMaster', 'subject_master_ref_id'),
			'mdmNewCourseEligibilities' => array(self::HAS_MANY, 'MdmNewCourseEligibility', 'student_subject_ref_id'),
			'studentEducationDetails' => array(self::HAS_MANY, 'StudentEducationDetail', 'student_subject_ref_id'),
			'studentPreferredSubjects' => array(self::HAS_MANY, 'StudentPreferredSubject', 'student_subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_subject_id' => 'Student Subject',
			'board_ref_id' => 'Board Ref',
			'subject_name' => 'Subject Name',
			'class' => 'Class',
			'subject_master_ref_id' => 'Subject Master Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_subject_id',$this->student_subject_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('subject_name',$this->subject_name,true);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('subject_master_ref_id',$this->subject_master_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}