<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupTimezone is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_timezone".
 *
 * The followings are the available columns in table 'lookup_timezone':
 * @property integer $timezone_id
 * @property integer $country_ref_id
 * @property string $timezone
 * @property string $utc_offset
 * @property string $utc_dst_offset
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Event[] $events
 * @property TblCountryMaster $countryRef
 */
class BaseLookupTimezone extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupTimezone the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_timezone';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, timezone, utc_offset, utc_dst_offset, added_on', 'required'),
			array('country_ref_id', 'numerical', 'integerOnly'=>true),
			array('timezone', 'length', 'max'=>32),
			array('utc_offset, utc_dst_offset', 'length', 'max'=>8),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('timezone_id, country_ref_id, timezone, utc_offset, utc_dst_offset, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'events' => array(self::HAS_MANY, 'Event', 'timezone_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'timezone_id' => 'Timezone',
			'country_ref_id' => 'Country Ref',
			'timezone' => 'Timezone',
			'utc_offset' => 'Utc Offset',
			'utc_dst_offset' => 'Utc Dst Offset',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('timezone_id',$this->timezone_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('timezone',$this->timezone,true);
		$criteria->compare('utc_offset',$this->utc_offset,true);
		$criteria->compare('utc_dst_offset',$this->utc_dst_offset,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}