<?php

/**
/*
 * @author Shastry Chamarthi
 * @package application.models 
 * 
 * BaseLookupUrl is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_url".
 *
 * The followings are the available columns in table 'lookup_url':
 * @property integer $url_id
 * @property string $url
 * @property integer $class_level
 * @property string $label
 * @property string $type_of_field
 * @property integer $redirect_order
 * @property string $model_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster[] $tblUserMasters
 */
class BaseLookupUrl extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupUrl the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_url';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('class_level, label, added_on', 'required'),
			array('class_level, redirect_order', 'numerical', 'integerOnly'=>true),
			array('url', 'length', 'max'=>500),
			array('label', 'length', 'max'=>50),
			array('type_of_field', 'length', 'max'=>11),
			array('model_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('url_id, url, class_level, label, type_of_field, redirect_order, model_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'redirect_url_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'url_id' => 'Url',
			'url' => 'Url',
			'class_level' => 'Class Level',
			'label' => 'Label',
			'type_of_field' => 'Type Of Field',
			'redirect_order' => 'Redirect Order',
			'model_name' => 'Model Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('url_id',$this->url_id);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('class_level',$this->class_level);
		$criteria->compare('label',$this->label,true);
		$criteria->compare('type_of_field',$this->type_of_field,true);
		$criteria->compare('redirect_order',$this->redirect_order);
		$criteria->compare('model_name',$this->model_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}