<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupUserInterestLevel is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_user_interest_level".
 *
 * The followings are the available columns in table 'lookup_user_interest_level':
 * @property integer $user_interest_level_id
 * @property integer $user_interest_ref_id
 * @property string $interest_level
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupUserInterest $userInterestRef
 * @property TblUserInterest[] $tblUserInterests
 */
class BaseLookupUserInterestLevel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupUserInterestLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_user_interest_level';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_interest_ref_id, interest_level', 'required'),
			array('user_interest_ref_id', 'numerical', 'integerOnly'=>true),
			array('interest_level', 'length', 'max'=>25),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_interest_level_id, user_interest_ref_id, interest_level, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userInterestRef' => array(self::BELONGS_TO, 'LookupUserInterest', 'user_interest_ref_id'),
			'tblUserInterests' => array(self::HAS_MANY, 'TblUserInterest', 'user_interest_level_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_interest_level_id' => 'User Interest Level',
			'user_interest_ref_id' => 'User Interest Ref',
			'interest_level' => 'Interest Level',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_interest_level_id',$this->user_interest_level_id);
		$criteria->compare('user_interest_ref_id',$this->user_interest_ref_id);
		$criteria->compare('interest_level',$this->interest_level,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}