<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupWorkplan is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_workplan".
 *
 * The followings are the available columns in table 'lookup_workplan':
 * @property integer $workplan_id
 * @property integer $workplan_stage_ref_id
 * @property integer $interaction_ref_id
 * @property string $activity_type
 * @property string $activity_name
 * @property integer $is_signoff
 * @property integer $display_order
 * @property integer $added_by
 * @property string $added_on
 * @property string $user_ref_id
 *
 * The followings are the available model relations:
 * @property LookupWorkplanStage $workplanStageRef
 * @property MasterInteraction $interactionRef
 * @property TblUserMaster $userRef
 * @property StudentWorkplan[] $studentWorkplans
 */
class BaseLookupWorkplan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupWorkplan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_workplan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workplan_stage_ref_id, added_on', 'required'),
			array('workplan_stage_ref_id, interaction_ref_id, is_signoff, display_order, added_by', 'numerical', 'integerOnly'=>true),
			array('activity_type', 'length', 'max'=>20),
			array('user_ref_id', 'length', 'max'=>10),
			array('activity_name', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workplan_id, workplan_stage_ref_id, interaction_ref_id, activity_type, activity_name, is_signoff, display_order, added_by, added_on, user_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'workplanStageRef' => array(self::BELONGS_TO, 'LookupWorkplanStage', 'workplan_stage_ref_id'),
			'interactionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'interaction_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'workplan_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workplan_id' => 'Workplan',
			'workplan_stage_ref_id' => 'Workplan Stage Ref',
			'interaction_ref_id' => 'Interaction Ref',
			'activity_type' => 'Activity Type',
			'activity_name' => 'Activity Name',
			'is_signoff' => 'Is Signoff',
			'display_order' => 'Display Order',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'user_ref_id' => 'User Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workplan_id',$this->workplan_id);
		$criteria->compare('workplan_stage_ref_id',$this->workplan_stage_ref_id);
		$criteria->compare('interaction_ref_id',$this->interaction_ref_id);
		$criteria->compare('activity_type',$this->activity_type,true);
		$criteria->compare('activity_name',$this->activity_name,true);
		$criteria->compare('is_signoff',$this->is_signoff);
		$criteria->compare('display_order',$this->display_order);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}