<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMdmCourseDump is autogenerate by UniModel generator
 *
 * This is the model class for table "mdm_course_dump".
 *
 * The followings are the available columns in table 'mdm_course_dump':
 * @property string $dump_id
 * @property string $course_ref_id
 * @property integer $source_ref_id
 * @property string $source_url
 * @property string $dump_text
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblUniCourses $courseRef
 * @property TblAdmin $modifiedBy
 * @property LookupMdmSource $sourceRef
 */
class BaseMdmCourseDump extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MdmCourseDump the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mdm_course_dump';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('course_ref_id, added_on, added_by', 'required'),
			array('source_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('course_ref_id', 'length', 'max'=>11),
			array('source_url', 'length', 'max'=>255),
			array('dump_text, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('dump_id, course_ref_id, source_ref_id, source_url, dump_text, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'courseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'course_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'sourceRef' => array(self::BELONGS_TO, 'LookupMdmSource', 'source_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'dump_id' => 'Dump',
			'course_ref_id' => 'Course Ref',
			'source_ref_id' => 'Source Ref',
			'source_url' => 'Source Url',
			'dump_text' => 'Dump Text',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('dump_id',$this->dump_id,true);
		$criteria->compare('course_ref_id',$this->course_ref_id,true);
		$criteria->compare('source_ref_id',$this->source_ref_id);
		$criteria->compare('source_url',$this->source_url,true);
		$criteria->compare('dump_text',$this->dump_text,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}