<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestSubjects is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_subjects".
 *
 * The followings are the available columns in table 'mock_test_subjects':
 * @property string $mock_test_subject_id
 * @property string $mock_test_ref_id
 * @property string $mockup_subject_ref_id
 *
 * The followings are the available model relations:
 * @property TblMockTest $mockTestRef
 * @property LookupMockupSubjects $mockupSubjectRef
 */
class BaseMockTestSubjects extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestSubjects the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_subjects';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mock_test_ref_id, mockup_subject_ref_id', 'required'),
			array('mock_test_ref_id, mockup_subject_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_subject_id, mock_test_ref_id, mockup_subject_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mockTestRef' => array(self::BELONGS_TO, 'TblMockTest', 'mock_test_ref_id'),
			'mockupSubjectRef' => array(self::BELONGS_TO, 'LookupMockupSubjects', 'mockup_subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_subject_id' => 'Mock Test Subject',
			'mock_test_ref_id' => 'Mock Test Ref',
			'mockup_subject_ref_id' => 'Mockup Subject Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_subject_id',$this->mock_test_subject_id,true);
		$criteria->compare('mock_test_ref_id',$this->mock_test_ref_id,true);
		$criteria->compare('mockup_subject_ref_id',$this->mockup_subject_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}