<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestUserAnswers is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_user_answers".
 *
 * The followings are the available columns in table 'mock_test_user_answers':
 * @property string $mock_test_user_answer_id
 * @property string $mock_test_result_ref_id
 * @property string $question_ref_id
 * @property string $option_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property MockTestResult $mockTestResultRef
 * @property MockTestQuestions $questionRef
 * @property MockTestQueOptions $optionRef
 */
class BaseMockTestUserAnswers extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestUserAnswers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_user_answers';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mock_test_result_ref_id, question_ref_id, option_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_user_answer_id, mock_test_result_ref_id, question_ref_id, option_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mockTestResultRef' => array(self::BELONGS_TO, 'MockTestResult', 'mock_test_result_ref_id'),
			'questionRef' => array(self::BELONGS_TO, 'MockTestQuestions', 'question_ref_id'),
			'optionRef' => array(self::BELONGS_TO, 'MockTestQueOptions', 'option_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_user_answer_id' => 'Mock Test User Answer',
			'mock_test_result_ref_id' => 'Mock Test Result Ref',
			'question_ref_id' => 'Question Ref',
			'option_ref_id' => 'Option Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_user_answer_id',$this->mock_test_user_answer_id,true);
		$criteria->compare('mock_test_result_ref_id',$this->mock_test_result_ref_id,true);
		$criteria->compare('question_ref_id',$this->question_ref_id,true);
		$criteria->compare('option_ref_id',$this->option_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}