<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseOnlineTestCode is autogenerate by UniModel generator
 *
 * This is the model class for table "online_test_code".
 *
 * The followings are the available columns in table 'online_test_code':
 * @property string $online_test_code_id
 * @property string $online_test_ref_id
 * @property string $coupon_code
 * @property string $user_ref_id
 * @property string $gateway_payment_ref_id
 * @property string $used_on
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property TblOnlineTest $onlineTestRef
 * @property TblUserMaster $userRef
 * @property GatewayPayment $gatewayPaymentRef
 * @property LoginMaster $addedBy
 */
class BaseOnlineTestCode extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OnlineTestCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'online_test_code';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('online_test_ref_id, user_ref_id, gateway_payment_ref_id, added_by', 'length', 'max'=>10),
			array('coupon_code', 'length', 'max'=>100),
			array('used_on, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('online_test_code_id, online_test_ref_id, coupon_code, user_ref_id, gateway_payment_ref_id, used_on, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'onlineTestRef' => array(self::BELONGS_TO, 'TblOnlineTest', 'online_test_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'gatewayPaymentRef' => array(self::BELONGS_TO, 'GatewayPayment', 'gateway_payment_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'online_test_code_id' => 'Online Test Code',
			'online_test_ref_id' => 'Online Test Ref',
			'coupon_code' => 'Coupon Code',
			'user_ref_id' => 'User Ref',
			'gateway_payment_ref_id' => 'Gateway Payment Ref',
			'used_on' => 'Used On',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('online_test_code_id',$this->online_test_code_id,true);
		$criteria->compare('online_test_ref_id',$this->online_test_ref_id,true);
		$criteria->compare('coupon_code',$this->coupon_code,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('gateway_payment_ref_id',$this->gateway_payment_ref_id,true);
		$criteria->compare('used_on',$this->used_on,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}