<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseOrderPayment is autogenerate by UniModel generator
 *
 * This is the model class for table "order_payment".
 *
 * The followings are the available columns in table 'order_payment':
 * @property string $order_payment_id
 * @property string $order_master_ref_id
 * @property integer $payment_type_ref_id
 * @property string $gateway_payment_ref_id
 * @property double $payment_amount
 * @property string $payment_date
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property GatewayPayment $gatewayPaymentRef
 * @property OrderMaster $orderMasterRef
 * @property LookupPaymentType $paymentTypeRef
 * @property PaymentCash[] $paymentCashes
 * @property PaymentCheque[] $paymentCheques
 * @property PaymentNeftRtgs[] $paymentNeftRtgs
 */
class BaseOrderPayment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrderPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'order_payment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_master_ref_id, payment_type_ref_id, payment_amount, added_by', 'required'),
			array('payment_type_ref_id', 'numerical', 'integerOnly'=>true),
			array('payment_amount', 'numerical'),
			array('order_master_ref_id, gateway_payment_ref_id, added_by', 'length', 'max'=>10),
			array('payment_date, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('order_payment_id, order_master_ref_id, payment_type_ref_id, gateway_payment_ref_id, payment_amount, payment_date, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'gatewayPaymentRef' => array(self::BELONGS_TO, 'GatewayPayment', 'gateway_payment_ref_id'),
			'orderMasterRef' => array(self::BELONGS_TO, 'OrderMaster', 'order_master_ref_id'),
			'paymentTypeRef' => array(self::BELONGS_TO, 'LookupPaymentType', 'payment_type_ref_id'),
			'paymentCashes' => array(self::HAS_MANY, 'PaymentCash', 'order_payment_ref_id'),
			'paymentCheques' => array(self::HAS_MANY, 'PaymentCheque', 'order_payment_ref_id'),
			'paymentNeftRtgs' => array(self::HAS_MANY, 'PaymentNeftRtgs', 'order_payment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'order_payment_id' => 'Order Payment',
			'order_master_ref_id' => 'Order Master Ref',
			'payment_type_ref_id' => 'Payment Type Ref',
			'gateway_payment_ref_id' => 'Gateway Payment Ref',
			'payment_amount' => 'Payment Amount',
			'payment_date' => 'Payment Date',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('order_payment_id',$this->order_payment_id,true);
		$criteria->compare('order_master_ref_id',$this->order_master_ref_id,true);
		$criteria->compare('payment_type_ref_id',$this->payment_type_ref_id);
		$criteria->compare('gateway_payment_ref_id',$this->gateway_payment_ref_id,true);
		$criteria->compare('payment_amount',$this->payment_amount);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}