<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePaymentNeftRtgs is autogenerate by UniModel generator
 *
 * This is the model class for table "payment_neft_rtgs".
 *
 * The followings are the available columns in table 'payment_neft_rtgs':
 * @property string $payment_neft_rtgs_id
 * @property string $order_payment_ref_id
 * @property string $neft_rtgs_number
 * @property double $amount
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property OrderPayment $orderPaymentRef
 */
class BasePaymentNeftRtgs extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PaymentNeftRtgs the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payment_neft_rtgs';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_payment_ref_id, neft_rtgs_number', 'required'),
			array('amount', 'numerical'),
			array('order_payment_ref_id', 'length', 'max'=>10),
			array('neft_rtgs_number', 'length', 'max'=>20),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('payment_neft_rtgs_id, order_payment_ref_id, neft_rtgs_number, amount, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderPaymentRef' => array(self::BELONGS_TO, 'OrderPayment', 'order_payment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'payment_neft_rtgs_id' => 'Payment Neft Rtgs',
			'order_payment_ref_id' => 'Order Payment Ref',
			'neft_rtgs_number' => 'Neft Rtgs Number',
			'amount' => 'Amount',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('payment_neft_rtgs_id',$this->payment_neft_rtgs_id,true);
		$criteria->compare('order_payment_ref_id',$this->order_payment_ref_id,true);
		$criteria->compare('neft_rtgs_number',$this->neft_rtgs_number,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}