<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProductDiscountCode is autogenerate by UniModel generator
 *
 * This is the model class for table "product_discount_code".
 *
 * The followings are the available columns in table 'product_discount_code':
 * @property string $product_discount_code_id
 * @property integer $product_ref_id
 * @property string $coupon_code
 * @property string $discount_amount
 * @property integer $max_uses
 * @property integer $used_counts
 * @property string $added_on
 * @property string $expires_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LookupProduct $productRef
 * @property LoginMaster $addedBy
 * @property ProductDiscountCodeUsers[] $productDiscountCodeUsers
 */
class BaseProductDiscountCode extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductDiscountCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_discount_code';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_ref_id, max_uses, used_counts', 'numerical', 'integerOnly'=>true),
			array('coupon_code', 'length', 'max'=>100),
			array('discount_amount, added_by', 'length', 'max'=>10),
			array('added_on, expires_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('product_discount_code_id, product_ref_id, coupon_code, discount_amount, max_uses, used_counts, added_on, expires_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'productDiscountCodeUsers' => array(self::HAS_MANY, 'ProductDiscountCodeUsers', 'product_discount_code_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'product_discount_code_id' => 'Product Discount Code',
			'product_ref_id' => 'Product Ref',
			'coupon_code' => 'Coupon Code',
			'discount_amount' => 'Discount Amount',
			'max_uses' => 'Max Uses',
			'used_counts' => 'Used Counts',
			'added_on' => 'Added On',
			'expires_on' => 'Expires On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('product_discount_code_id',$this->product_discount_code_id,true);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('coupon_code',$this->coupon_code,true);
		$criteria->compare('discount_amount',$this->discount_amount,true);
		$criteria->compare('max_uses',$this->max_uses);
		$criteria->compare('used_counts',$this->used_counts);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('expires_on',$this->expires_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}