<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProfileScoreInteraction is autogenerate by UniModel generator
 *
 * This is the model class for table "profile_score_interaction".
 *
 * The followings are the available columns in table 'profile_score_interaction':
 * @property string $profile_score_interaction_id
 * @property string $user_profile_score_ref_id
 * @property integer $user_status
 * @property string $next_interaction
 * @property string $status_comment
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property UserProfileScore $userProfileScoreRef
 * @property LookupProfileScoreStatus $userStatus
 */
class BaseProfileScoreInteraction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProfileScoreInteraction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'profile_score_interaction';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_status, added_by', 'numerical', 'integerOnly'=>true),
			array('user_profile_score_ref_id', 'length', 'max'=>10),
			array('next_interaction, status_comment, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('profile_score_interaction_id, user_profile_score_ref_id, user_status, next_interaction, status_comment, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'userProfileScoreRef' => array(self::BELONGS_TO, 'UserProfileScore', 'user_profile_score_ref_id'),
			'userStatus' => array(self::BELONGS_TO, 'LookupProfileScoreStatus', 'user_status'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_score_interaction_id' => 'Profile Score Interaction',
			'user_profile_score_ref_id' => 'User Profile Score Ref',
			'user_status' => 'User Status',
			'next_interaction' => 'Next Interaction',
			'status_comment' => 'Status Comment',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_score_interaction_id',$this->profile_score_interaction_id,true);
		$criteria->compare('user_profile_score_ref_id',$this->user_profile_score_ref_id,true);
		$criteria->compare('user_status',$this->user_status);
		$criteria->compare('next_interaction',$this->next_interaction,true);
		$criteria->compare('status_comment',$this->status_comment,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}