<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProspectReport is autogenerate by UniModel generator
 *
 * This is the model class for table "prospect_report".
 *
 * The followings are the available columns in table 'prospect_report':
 * @property integer $advisor_ref_id
 * @property string $total
 * @property string $active
 * @property string $not_interested
 * @property string $converted
 * @property string $abandoned
 * @property string $lost
 * @property string $avg_interactions_per_student
 * @property string $avg_interactions_per_conversion
 * @property string $avg_interactions_per_lost
 * @property string $avg_days_per_lost
 * @property string $avg_days_per_converted
 * @property string $avg_days_per_abandon
 * @property string $avg_days_per_prospect
 */
class BaseProspectReport extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProspectReport the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'prospect_report';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('advisor_ref_id', 'required'),
			array('advisor_ref_id', 'numerical', 'integerOnly'=>true),
			array('total, active, not_interested, converted, abandoned, lost', 'length', 'max'=>21),
			array('avg_interactions_per_student, avg_interactions_per_conversion, avg_interactions_per_lost', 'length', 'max'=>24),
			array('avg_days_per_lost, avg_days_per_converted, avg_days_per_abandon, avg_days_per_prospect', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('advisor_ref_id, total, active, not_interested, converted, abandoned, lost, avg_interactions_per_student, avg_interactions_per_conversion, avg_interactions_per_lost, avg_days_per_lost, avg_days_per_converted, avg_days_per_abandon, avg_days_per_prospect', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'advisor_ref_id' => 'Advisor Ref',
			'total' => 'Total',
			'active' => 'Active',
			'not_interested' => 'Not Interested',
			'converted' => 'Converted',
			'abandoned' => 'Abandoned',
			'lost' => 'Lost',
			'avg_interactions_per_student' => 'Avg Interactions Per Student',
			'avg_interactions_per_conversion' => 'Avg Interactions Per Conversion',
			'avg_interactions_per_lost' => 'Avg Interactions Per Lost',
			'avg_days_per_lost' => 'Avg Days Per Lost',
			'avg_days_per_converted' => 'Avg Days Per Converted',
			'avg_days_per_abandon' => 'Avg Days Per Abandon',
			'avg_days_per_prospect' => 'Avg Days Per Prospect',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('total',$this->total,true);
		$criteria->compare('active',$this->active,true);
		$criteria->compare('not_interested',$this->not_interested,true);
		$criteria->compare('converted',$this->converted,true);
		$criteria->compare('abandoned',$this->abandoned,true);
		$criteria->compare('lost',$this->lost,true);
		$criteria->compare('avg_interactions_per_student',$this->avg_interactions_per_student,true);
		$criteria->compare('avg_interactions_per_conversion',$this->avg_interactions_per_conversion,true);
		$criteria->compare('avg_interactions_per_lost',$this->avg_interactions_per_lost,true);
		$criteria->compare('avg_days_per_lost',$this->avg_days_per_lost,true);
		$criteria->compare('avg_days_per_converted',$this->avg_days_per_converted,true);
		$criteria->compare('avg_days_per_abandon',$this->avg_days_per_abandon,true);
		$criteria->compare('avg_days_per_prospect',$this->avg_days_per_prospect,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}