<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseReviewCredit is autogenerate by UniModel generator
 *
 * This is the model class for table "review_credit".
 *
 * The followings are the available columns in table 'review_credit':
 * @property string $review_credit_id
 * @property string $user_ref_id
 * @property string $credit_from
 * @property string $added_on
 * @property string $used_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseReviewCredit extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ReviewCredit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'review_credit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('credit_from, added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('credit_from', 'length', 'max'=>6),
			array('used_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('review_credit_id, user_ref_id, credit_from, added_on, used_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'review_credit_id' => 'Review Credit',
			'user_ref_id' => 'User Ref',
			'credit_from' => 'Credit From',
			'added_on' => 'Added On',
			'used_on' => 'Used On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('review_credit_id',$this->review_credit_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('credit_from',$this->credit_from,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('used_on',$this->used_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}