<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship".
 *
 * The followings are the available columns in table 'scholarship':
 * @property string $scholarship_id
 * @property string $scholarship_name
 * @property string $url_primary_key
 * @property string $seo_keyword
 * @property integer $scholarship_provider_ref_id
 * @property string $scholarship_provider_name
 * @property string $website
 * @property string $email_id
 * @property string $eligibility_criteria
 * @property string $scholarship_description
 * @property string $Scholarship_Applicable_for
 * @property integer $currency_ref_id
 * @property string $amount
 * @property string $frequency
 * @property string $Scholarship_Amount_text
 * @property string $contact_address
 * @property integer $deadline_day
 * @property integer $deadline_month
 * @property integer $deadline_year
 * @property string $additional_information
 * @property string $number_of_scholarships
 * @property integer $notification_fees_currency_ref_id
 * @property string $notification_fees_amount
 * @property string $application_requirements
 * @property string $gender
 * @property integer $scholarship_type_ref_id
 * @property string $destination_country_region
 * @property string $host_institution_commentary
 * @property string $address1
 * @property string $address2
 * @property integer $city_ref_id
 * @property integer $country_ref_id
 * @property string $postcode
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property DiUserEoiScholarship[] $diUserEoiScholarships
 * @property DiUserEoiScholarshipLog[] $diUserEoiScholarshipLogs
 * @property LoginMaster $addedBy
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $modifiedBy
 * @property LookupCurrency $notificationFeesCurrencyRef
 * @property LookupScholarshipProviderType $scholarshipProviderRef
 * @property LookupScholarshipType $scholarshipTypeRef
 * @property ScholarshipAge[] $scholarshipAges
 * @property ScholarshipContact[] $scholarshipContacts
 * @property ScholarshipDepartment[] $scholarshipDepartments
 * @property ScholarshipDestinationCountry[] $scholarshipDestinationCountries
 * @property ScholarshipEligibilityClass[] $scholarshipEligibilityClasses
 * @property ScholarshipEligibilityEntrance[] $scholarshipEligibilityEntrances
 * @property ScholarshipFinancialNeed[] $scholarshipFinancialNeeds
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes
 * @property ScholarshipTarget[] $scholarshipTargets
 * @property UserScholarship[] $userScholarships
 */
class BaseScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Scholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_name, added_on', 'required'),
			array('scholarship_provider_ref_id, currency_ref_id, deadline_day, deadline_month, deadline_year, notification_fees_currency_ref_id, scholarship_type_ref_id, city_ref_id, country_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('scholarship_provider_name, email_id, number_of_scholarships, address1, address2', 'length', 'max'=>100),
			array('scholarship_name', 'length', 'max'=>255),
			array('url_primary_key', 'length', 'max'=>32),
			array('seo_keyword', 'length', 'max'=>50),
			array('website', 'length', 'max'=>255),
			array('amount, notification_fees_amount, added_by, modified_by', 'length', 'max'=>10),
			array('frequency, gender', 'length', 'max'=>6),
			array('postcode', 'length', 'max'=>16),
			array('eligibility_criteria, scholarship_description, Scholarship_Applicable_for, Scholarship_Amount_text, contact_address, additional_information, application_requirements, destination_country_region, host_institution_commentary, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_id, scholarship_name, url_primary_key, seo_keyword, scholarship_provider_ref_id, scholarship_provider_name, website, email_id, eligibility_criteria, scholarship_description, Scholarship_Applicable_for, currency_ref_id, amount, frequency, Scholarship_Amount_text, contact_address, deadline_day, deadline_month, deadline_year, additional_information, number_of_scholarships, notification_fees_currency_ref_id, notification_fees_amount, application_requirements, gender, scholarship_type_ref_id, destination_country_region, host_institution_commentary, address1, address2, city_ref_id, country_ref_id, postcode, added_on, added_by, modified_on, modified_by, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserEoiScholarships' => array(self::HAS_MANY, 'DiUserEoiScholarship', 'scholarship_ref_id'),
			'diUserEoiScholarshipLogs' => array(self::HAS_MANY, 'DiUserEoiScholarshipLog', 'scholarship_log_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'notificationFeesCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'notification_fees_currency_ref_id'),
			'scholarshipProviderRef' => array(self::BELONGS_TO, 'LookupScholarshipProviderType', 'scholarship_provider_ref_id'),
			'scholarshipTypeRef' => array(self::BELONGS_TO, 'LookupScholarshipType', 'scholarship_type_ref_id'),
			'scholarshipAges' => array(self::HAS_MANY, 'ScholarshipAge', 'scholarship_ref_id'),
			'scholarshipContacts' => array(self::HAS_MANY, 'ScholarshipContact', 'scholarship_ref_id'),
			'scholarshipDepartments' => array(self::HAS_MANY, 'ScholarshipDepartment', 'scholarship_ref_id'),
			'scholarshipDestinationCountries' => array(self::HAS_MANY, 'ScholarshipDestinationCountry', 'scholarship_ref_id'),
			'scholarshipEligibilityClasses' => array(self::HAS_MANY, 'ScholarshipEligibilityClass', 'scholarship_ref_id'),
			'scholarshipEligibilityEntrances' => array(self::HAS_MANY, 'ScholarshipEligibilityEntrance', 'scholarship_ref_id'),
			'scholarshipFinancialNeeds' => array(self::HAS_MANY, 'ScholarshipFinancialNeed', 'scholarship_ref_id'),
			'scholarshipHostInstitutes' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'scholarship_ref_id'),
			'scholarshipTargets' => array(self::HAS_MANY, 'ScholarshipTarget', 'scholarship_ref_id'),
			'userScholarships' => array(self::HAS_MANY, 'UserScholarship', 'scholarship_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_id' => 'Scholarship',
			'scholarship_name' => 'Scholarship Name',
			'url_primary_key' => 'Url Primary Key',
			'seo_keyword' => 'Seo Keyword',
			'scholarship_provider_ref_id' => 'Scholarship Provider Ref',
			'scholarship_provider_name' => 'Scholarship Provider Name',
			'website' => 'Website',
			'email_id' => 'Email',
			'eligibility_criteria' => 'Eligibility Criteria',
			'scholarship_description' => 'Scholarship Description',
			'Scholarship_Applicable_for' => 'Scholarship Applicable For',
			'currency_ref_id' => 'Currency Ref',
			'amount' => 'Amount',
			'frequency' => 'Frequency',
			'Scholarship_Amount_text' => 'Scholarship Amount Text',
			'contact_address' => 'Contact Address',
			'deadline_day' => 'Deadline Day',
			'deadline_month' => 'Deadline Month',
			'deadline_year' => 'Deadline Year',
			'additional_information' => 'Additional Information',
			'number_of_scholarships' => 'Number Of Scholarships',
			'notification_fees_currency_ref_id' => 'Notification Fees Currency Ref',
			'notification_fees_amount' => 'Notification Fees Amount',
			'application_requirements' => 'Application Requirements',
			'gender' => 'Gender',
			'scholarship_type_ref_id' => 'Scholarship Type Ref',
			'destination_country_region' => 'Destination Country Region',
			'host_institution_commentary' => 'Host Institution Commentary',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city_ref_id' => 'City Ref',
			'country_ref_id' => 'Country Ref',
			'postcode' => 'Postcode',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_active' => 'Is Active',
			'tentative' => 'Tentative',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_id',$this->scholarship_id,true);
		$criteria->compare('scholarship_name',$this->scholarship_name,true);
		$criteria->compare('url_primary_key',$this->url_primary_key,true);
		$criteria->compare('seo_keyword',$this->seo_keyword,true);
		$criteria->compare('scholarship_provider_ref_id',$this->scholarship_provider_ref_id);
		$criteria->compare('scholarship_provider_name',$this->scholarship_provider_name,true);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('eligibility_criteria',$this->eligibility_criteria,true);
		$criteria->compare('scholarship_description',$this->scholarship_description,true);
		$criteria->compare('Scholarship_Applicable_for',$this->Scholarship_Applicable_for,true);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('frequency',$this->frequency,true);
		$criteria->compare('Scholarship_Amount_text',$this->Scholarship_Amount_text,true);
		$criteria->compare('contact_address',$this->contact_address,true);
		$criteria->compare('deadline_day',$this->deadline_day);
		$criteria->compare('deadline_month',$this->deadline_month);
		$criteria->compare('deadline_year',$this->deadline_year);
		$criteria->compare('additional_information',$this->additional_information,true);
		$criteria->compare('number_of_scholarships',$this->number_of_scholarships,true);
		$criteria->compare('notification_fees_currency_ref_id',$this->notification_fees_currency_ref_id);
		$criteria->compare('notification_fees_amount',$this->notification_fees_amount,true);
		$criteria->compare('application_requirements',$this->application_requirements,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('scholarship_type_ref_id',$this->scholarship_type_ref_id);
		$criteria->compare('destination_country_region',$this->destination_country_region,true);
		$criteria->compare('host_institution_commentary',$this->host_institution_commentary,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('postcode',$this->postcode,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}