<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipContact is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_contact".
 *
 * The followings are the available columns in table 'scholarship_contact':
 * @property integer $scholarship_contact_id
 * @property string $scholarship_ref_id
 * @property string $country_code
 * @property string $state_code
 * @property string $contact_number
 * @property string $phone_type
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property Scholarship $scholarshipRef
 */
class BaseScholarshipContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, contact_number', 'required'),
			array('scholarship_ref_id, country_code, state_code, added_by, modified_by', 'length', 'max'=>10),
			array('contact_number', 'length', 'max'=>15),
			array('phone_type', 'length', 'max'=>8),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_contact_id, scholarship_ref_id, country_code, state_code, contact_number, phone_type, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_contact_id' => 'Scholarship Contact',
			'scholarship_ref_id' => 'Scholarship Ref',
			'country_code' => 'Country Code',
			'state_code' => 'State Code',
			'contact_number' => 'Contact Number',
			'phone_type' => 'Phone Type',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_contact_id',$this->scholarship_contact_id);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('state_code',$this->state_code,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('phone_type',$this->phone_type,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}