<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipEligibilityEntrance is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_eligibility_entrance".
 *
 * The followings are the available columns in table 'scholarship_eligibility_entrance':
 * @property string $scholarship_eligibility_entrance_id
 * @property string $scholarship_ref_id
 * @property integer $entrance_ref_Id
 * @property double $marks_required
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property Scholarship $scholarshipRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseScholarshipEligibilityEntrance extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipEligibilityEntrance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_eligibility_entrance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('scholarship_ref_id, entrance_ref_Id, added_by', 'required'),
			array('entrance_ref_Id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('marks_required', 'numerical'),
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_eligibility_entrance_id, scholarship_ref_id, entrance_ref_Id, marks_required, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                        'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_Id'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_eligibility_entrance_id' => 'Scholarship Eligibility Entrance',
			'scholarship_ref_id' => 'Scholarship Ref',
			'entrance_ref_Id' => 'Entrance Ref',
			'marks_required' => 'Marks Required',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_eligibility_entrance_id',$this->scholarship_eligibility_entrance_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('entrance_ref_Id',$this->entrance_ref_Id);
		$criteria->compare('marks_required',$this->marks_required);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}