<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipHostInstitute is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_host_institute".
 *
 * The followings are the available columns in table 'scholarship_host_institute':
 * @property string $scholarship_host_institute_id
 * @property string $scholarship_ref_id
 * @property integer $continent_ref_id
 * @property integer $country_ref_id
 * @property string $university_type
 * @property integer $uni_ref_id
 * @property string $non_univariety_uni_name
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property LookupContinent $continentRef
 * @property LoginMaster $addedBy
 * @property TblCountryMaster $countryRef
 * @property LoginMaster $modifiedBy
 * @property Scholarship $scholarshipRef
 * @property TblUniversityMaster $uniRef
 */
class BaseScholarshipHostInstitute extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipHostInstitute the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_host_institute';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_by', 'required'),
			array('continent_ref_id, country_ref_id, uni_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('university_type', 'length', 'max'=>13),
			array('non_univariety_uni_name', 'length', 'max'=>255),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_host_institute_id, scholarship_ref_id, continent_ref_id, country_ref_id, university_type, uni_ref_id, non_univariety_uni_name, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'continentRef' => array(self::BELONGS_TO, 'LookupContinent', 'continent_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_host_institute_id' => 'Scholarship Host Institute',
			'scholarship_ref_id' => 'Scholarship Ref',
			'continent_ref_id' => 'Continent Ref',
			'country_ref_id' => 'Country Ref',
			'university_type' => 'University Type',
			'uni_ref_id' => 'Uni Ref',
			'non_univariety_uni_name' => 'Non Univariety Uni Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_host_institute_id',$this->scholarship_host_institute_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('continent_ref_id',$this->continent_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('university_type',$this->university_type,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('non_univariety_uni_name',$this->non_univariety_uni_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}