<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipTarget is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_target".
 *
 * The followings are the available columns in table 'scholarship_target':
 * @property string $scholarship_target_id
 * @property string $scholarship_ref_id
 * @property integer $scholarship_target_group_ref_id
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property Scholarship $scholarshipRef
 * @property LookupScholarshipTargetGroup $scholarshipTargetGroupRef
 */
class BaseScholarshipTarget extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipTarget the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_target';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, scholarship_target_group_ref_id, added_on', 'required'),
			array('scholarship_target_group_ref_id', 'numerical', 'integerOnly'=>true),
			array('scholarship_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_target_id, scholarship_ref_id, scholarship_target_group_ref_id, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'scholarshipTargetGroupRef' => array(self::BELONGS_TO, 'LookupScholarshipTargetGroup', 'scholarship_target_group_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_target_id' => 'Scholarship Target',
			'scholarship_ref_id' => 'Scholarship Ref',
			'scholarship_target_group_ref_id' => 'Scholarship Target Group Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_target_id',$this->scholarship_target_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('scholarship_target_group_ref_id',$this->scholarship_target_group_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}