<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSeoCountry is autogenerate by UniModel generator
 *
 * This is the model class for table "seo_country".
 *
 * The followings are the available columns in table 'seo_country':
 * @property string $seo_country_id
 * @property integer $country_ref_id
 * @property string $seo_country_name
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 */
class BaseSeoCountry extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SeoCountry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'seo_country';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, seo_country_name', 'required'),
			array('country_ref_id', 'numerical', 'integerOnly'=>true),
			array('seo_country_name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('seo_country_id, country_ref_id, seo_country_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'seo_country_id' => 'Seo Country',
			'country_ref_id' => 'Country Ref',
			'seo_country_name' => 'Seo Country Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('seo_country_id',$this->seo_country_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('seo_country_name',$this->seo_country_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}