<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSessionBookingTimeslot is autogenerate by UniModel generator
 *
 * This is the model class for table "session_booking_timeslot".
 *
 * The followings are the available columns in table 'session_booking_timeslot':
 * @property string $booking_timeslot_id
 * @property string $timeslot_ref_id
 * @property string $booking_ref_id
 * @property integer $is_booking
 * @property string $added_on
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property SessionTimeslot $timeslotRef
 * @property SessionBooking $bookingRef
 */
class BaseSessionBookingTimeslot extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SessionBookingTimeslot the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'session_booking_timeslot';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('timeslot_ref_id, booking_ref_id, added_on', 'required'),
			array('is_booking', 'numerical', 'integerOnly'=>true),
			array('timeslot_ref_id, booking_ref_id', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('booking_timeslot_id, timeslot_ref_id, booking_ref_id, is_booking, added_on, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'timeslotRef' => array(self::BELONGS_TO, 'SessionTimeslot', 'timeslot_ref_id'),
			'bookingRef' => array(self::BELONGS_TO, 'SessionBooking', 'booking_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'booking_timeslot_id' => 'Booking Timeslot',
			'timeslot_ref_id' => 'Timeslot Ref',
			'booking_ref_id' => 'Booking Ref',
			'is_booking' => 'Is Booking',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('booking_timeslot_id',$this->booking_timeslot_id,true);
		$criteria->compare('timeslot_ref_id',$this->timeslot_ref_id,true);
		$criteria->compare('booking_ref_id',$this->booking_ref_id,true);
		$criteria->compare('is_booking',$this->is_booking);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}