<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSiMilestoneDate is autogenerate by UniModel generator
 *
 * This is the model class for table "si_milestone_date".
 *
 * The followings are the available columns in table 'si_milestone_date':
 * @property string $si_milestone_date_id
 * @property integer $si_ref_id
 * @property integer $milestone_id
 * @property string $class
 * @property integer $board_ref_id
 * @property string $milestone_date
 * @property integer $passout_year
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupBoard $boardRef
 * @property LoginMaster $modifiedBy
 * @property TblSiDi $siRef
 */
class BaseSiMilestoneDate extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SiMilestoneDate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'si_milestone_date';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('si_ref_id, milestone_id, milestone_date, added_on, added_by', 'required'),
			array('si_ref_id, milestone_id, board_ref_id, passout_year', 'numerical', 'integerOnly'=>true),
			array('class', 'length', 'max'=>2),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('si_milestone_date_id, si_ref_id, milestone_id, class, board_ref_id, milestone_date, passout_year, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'si_milestone_date_id' => 'Si Milestone Date',
			'si_ref_id' => 'Si Ref',
			'milestone_id' => 'Milestone',
			'class' => 'Class',
			'board_ref_id' => 'Board Ref',
			'milestone_date' => 'Milestone Date',
			'passout_year' => 'Passout Year',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('si_milestone_date_id',$this->si_milestone_date_id,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('milestone_id',$this->milestone_id);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('milestone_date',$this->milestone_date,true);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}