<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentActivityFeed is autogenerate by UniModel generator
 *
 * This is the model class for table "student_activity_feed".
 *
 * The followings are the available columns in table 'student_activity_feed':
 * @property string $student_activity_feed_id
 * @property string $user_ref_id
 * @property integer $activity_ref_id
 * @property string $activity_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupActivity $activityRef
 */
class BaseStudentActivityFeed extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentActivityFeed the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_activity_feed';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, activity_ref_id, added_on', 'required'),
			array('activity_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('activity_type', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_activity_feed_id, user_ref_id, activity_ref_id, activity_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'activityRef' => array(self::BELONGS_TO, 'LookupActivity', 'activity_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_activity_feed_id' => 'Student Activity Feed',
			'user_ref_id' => 'User Ref',
			'activity_ref_id' => 'Activity Ref',
			'activity_type' => 'Activity Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_activity_feed_id',$this->student_activity_feed_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('activity_ref_id',$this->activity_ref_id);
		$criteria->compare('activity_type',$this->activity_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}