<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentEducationDetail is autogenerate by UniModel generator
 *
 * This is the model class for table "student_education_detail".
 *
 * The followings are the available columns in table 'student_education_detail':
 * @property string $student_education_detail_id
 * @property string $student_education_ref_id
 * @property integer $student_subject_ref_id
 * @property double $marks
 * @property double $max_subject_marks
 * @property string $other_subject
 * @property integer $grade_ref_id
 * @property string $grade
 * @property integer $board_conversion_ref_id
 * @property integer $points
 * @property string $ib_level
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupBoardConversion $boardConversionRef
 * @property LookupGrade $gradeRef
 * @property StudentEducation $studentEducationRef
 * @property LookupStudentSubject $studentSubjectRef
 */
class BaseStudentEducationDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentEducationDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_education_detail';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_education_ref_id, student_subject_ref_id, added_on', 'required'),
			array('student_subject_ref_id, grade_ref_id, board_conversion_ref_id, points', 'numerical', 'integerOnly'=>true),
			array('marks, max_subject_marks', 'numerical'),
			array('student_education_ref_id', 'length', 'max'=>10),
			array('other_subject', 'length', 'max'=>45),
			array('grade', 'length', 'max'=>3),
			array('ib_level', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_education_detail_id, student_education_ref_id, student_subject_ref_id, marks, max_subject_marks, other_subject, grade_ref_id, grade, board_conversion_ref_id, points, ib_level, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'boardConversionRef' => array(self::BELONGS_TO, 'LookupBoardConversion', 'board_conversion_ref_id'),
			'gradeRef' => array(self::BELONGS_TO, 'LookupGrade', 'grade_ref_id'),
			'studentEducationRef' => array(self::BELONGS_TO, 'StudentEducation', 'student_education_ref_id'),
			'studentSubjectRef' => array(self::BELONGS_TO, 'LookupStudentSubject', 'student_subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_education_detail_id' => 'Student Education Detail',
			'student_education_ref_id' => 'Student Education Ref',
			'student_subject_ref_id' => 'Student Subject Ref',
			'marks' => 'Marks',
			'max_subject_marks' => 'Max Subject Marks',
			'other_subject' => 'Other Subject',
			'grade_ref_id' => 'Grade Ref',
			'grade' => 'Grade',
			'board_conversion_ref_id' => 'Board Conversion Ref',
			'points' => 'Points',
			'ib_level' => 'Ib Level',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_education_detail_id',$this->student_education_detail_id,true);
		$criteria->compare('student_education_ref_id',$this->student_education_ref_id,true);
		$criteria->compare('student_subject_ref_id',$this->student_subject_ref_id);
		$criteria->compare('marks',$this->marks);
		$criteria->compare('max_subject_marks',$this->max_subject_marks);
		$criteria->compare('other_subject',$this->other_subject,true);
		$criteria->compare('grade_ref_id',$this->grade_ref_id);
		$criteria->compare('grade',$this->grade,true);
		$criteria->compare('board_conversion_ref_id',$this->board_conversion_ref_id);
		$criteria->compare('points',$this->points);
		$criteria->compare('ib_level',$this->ib_level,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}