<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentHotlead is autogenerate by UniModel generator
 *
 * This is the model class for table "student_hotlead".
 *
 * The followings are the available columns in table 'student_hotlead':
 * @property string $student_hotlead_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property string $status
 * @property integer $profile_match_percent
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiUserHotlead[] $diUserHotleads
 * @property TblUserMaster $userRef
 * @property TblUniversityMaster $uniRef
 * @property LoginMaster $addedBy
 */
class BaseStudentHotlead extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentHotlead the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_hotlead';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, uni_ref_id, added_by, added_on', 'required'),
			array('uni_ref_id, profile_match_percent', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, status, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_hotlead_id, user_ref_id, uni_ref_id, status, profile_match_percent, added_by, added_on', 'safe', 'on'=>'search'),
            array('modified_on, modified_by', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserHotleads' => array(self::HAS_MANY, 'DiUserHotlead', 'student_hotlead_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_hotlead_id' => 'Student Hotlead',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'status' => 'Status',
			'profile_match_percent' => 'Profile Match Percent',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_hotlead_id',$this->student_hotlead_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('profile_match_percent',$this->profile_match_percent);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}