<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentHypothesisDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "student_hypothesis_department".
 *
 * The followings are the available columns in table 'student_hypothesis_department':
 * @property string $student_hypothesis_department_id
 * @property string $user_ref_id
 * @property integer $main_dept_ref_id
 * @property integer $sub_dept_ref_id
 * @property integer $preference_order
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDepartment $mainDeptRef
 * @property LookupDepartment $subDeptRef
 * @property TblUserMaster $userRef
 * @property LoginMaster $addedBy
 */
class BaseStudentHypothesisDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentHypothesisDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_hypothesis_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by', 'required'),
			array('main_dept_ref_id, sub_dept_ref_id, preference_order', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_hypothesis_department_id, user_ref_id, main_dept_ref_id, sub_dept_ref_id, preference_order, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_hypothesis_department_id' => 'Student Hypothesis Department',
			'user_ref_id' => 'User Ref',
			'main_dept_ref_id' => 'Main Dept Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'preference_order' => 'Preference Order',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_hypothesis_department_id',$this->student_hypothesis_department_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('preference_order',$this->preference_order);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}