<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementEducation is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_education".
 *
 * The followings are the available columns in table 'student_outplacement_education':
 * @property string $student_outplacement_education_id
 * @property string $user_ref_id
 * @property string $education_status
 * @property string $education_qualification
 * @property string $others
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseStudentOutplacementEducation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementEducation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_education';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, education_status', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('education_status', 'length', 'max'=>1),
			array('education_qualification', 'length', 'max'=>6),
			array('others, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_education_id, user_ref_id, education_status, education_qualification, others, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_education_id' => 'Student Outplacement Education',
			'user_ref_id' => 'User Ref',
			'education_status' => 'Education Status',
			'education_qualification' => 'Education Qualification',
			'others' => 'Others',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_education_id',$this->student_outplacement_education_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('education_status',$this->education_status,true);
		$criteria->compare('education_qualification',$this->education_qualification,true);
		$criteria->compare('others',$this->others,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}