<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementTestsMarks is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_tests_marks".
 *
 * The followings are the available columns in table 'student_outplacement_tests_marks':
 * @property string $student_outplacement_tests_marks_id
 * @property string $student_outplacement_tests_ref_id
 * @property integer $subject_ref_id
 * @property string $marks
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property StudentOutplacementTests $studentOutplacementTestsRef
 * @property EntranceExamModule $subjectRef
 */
class BaseStudentOutplacementTestsMarks extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementTestsMarks the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_tests_marks';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_outplacement_tests_ref_id, subject_ref_id', 'required'),
			array('subject_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_outplacement_tests_ref_id', 'length', 'max'=>10),
			array('marks', 'length', 'max'=>5),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_tests_marks_id, student_outplacement_tests_ref_id, subject_ref_id, marks, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentOutplacementTestsRef' => array(self::BELONGS_TO, 'StudentOutplacementTests', 'student_outplacement_tests_ref_id'),
			'subjectRef' => array(self::BELONGS_TO, 'EntranceExamModule', 'subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_tests_marks_id' => 'Student Outplacement Tests Marks',
			'student_outplacement_tests_ref_id' => 'Student Outplacement Tests Ref',
			'subject_ref_id' => 'Subject Ref',
			'marks' => 'Marks',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_tests_marks_id',$this->student_outplacement_tests_marks_id,true);
		$criteria->compare('student_outplacement_tests_ref_id',$this->student_outplacement_tests_ref_id,true);
		$criteria->compare('subject_ref_id',$this->subject_ref_id);
		$criteria->compare('marks',$this->marks,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}