<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_university".
 *
 * The followings are the available columns in table 'student_outplacement_university':
 * @property string $student_outplacement_university_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $sub_dept_name
 * @property string $course_ref_id
 * @property string $uni_name
 * @property string $course_name
 * @property string $uni_type
 * @property string $fees
 * @property integer $fees_currency_ref_id
 * @property string $loan_amount
 * @property integer $loan_currency_ref_id
 * @property string $loan_source
 * @property string $bank_name
 * @property string $added_on
 * @property string $added_by
 * @property string $list_type
 * @property integer $has_loan
 * @property integer $has_scholarship
 * @property integer $status
 *
 * The followings are the available model relations:
 * @property LookupDepartment $subDeptRef
 * @property TblUniversityMaster $uniRef
 * @property TblUniCourses $courseRef
 * @property LookupCurrency $feesCurrencyRef
 * @property LookupCurrency $loanCurrencyRef
 * @property TblUserMaster $userRef
 */
class BaseStudentOutplacementUniversity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementUniversity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_university';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_on, added_by', 'required'),
			array('uni_ref_id, sub_dept_ref_id, fees_currency_ref_id, loan_currency_ref_id, has_loan, has_scholarship, status', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, course_ref_id, fees, loan_amount, added_by', 'length', 'max'=>10),
			array('sub_dept_name', 'length', 'max'=>100),
			array('uni_name, course_name, bank_name', 'length', 'max'=>255),
			array('uni_type', 'length', 'max'=>17),
			array('loan_source', 'length', 'max'=>8),
			array('list_type', 'length', 'max'=>12),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_university_id, user_ref_id, uni_ref_id, sub_dept_ref_id, sub_dept_name, course_ref_id, uni_name, course_name, uni_type, fees, fees_currency_ref_id, loan_amount, loan_currency_ref_id, loan_source, bank_name, added_on, added_by, list_type, has_loan, has_scholarship, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'courseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'course_ref_id'),
			'feesCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'fees_currency_ref_id'),
			'loanCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'loan_currency_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_university_id' => 'Student Outplacement University',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'sub_dept_name' => 'Sub Dept Name',
			'course_ref_id' => 'Course Ref',
			'uni_name' => 'Uni Name',
			'course_name' => 'Course Name',
			'uni_type' => 'Uni Type',
			'fees' => 'Fees',
			'fees_currency_ref_id' => 'Fees Currency Ref',
			'loan_amount' => 'Loan Amount',
			'loan_currency_ref_id' => 'Loan Currency Ref',
			'loan_source' => 'Loan Source',
			'bank_name' => 'Bank Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'list_type' => 'List Type',
			'has_loan' => 'Has Loan',
			'has_scholarship' => 'Has Scholarship',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_university_id',$this->student_outplacement_university_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('sub_dept_name',$this->sub_dept_name,true);
		$criteria->compare('course_ref_id',$this->course_ref_id,true);
		$criteria->compare('uni_name',$this->uni_name,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('uni_type',$this->uni_type,true);
		$criteria->compare('fees',$this->fees,true);
		$criteria->compare('fees_currency_ref_id',$this->fees_currency_ref_id);
		$criteria->compare('loan_amount',$this->loan_amount,true);
		$criteria->compare('loan_currency_ref_id',$this->loan_currency_ref_id);
		$criteria->compare('loan_source',$this->loan_source,true);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('list_type',$this->list_type,true);
		$criteria->compare('has_loan',$this->has_loan);
		$criteria->compare('has_scholarship',$this->has_scholarship);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}