<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementUniversityScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_university_scholarship".
 *
 * The followings are the available columns in table 'student_outplacement_university_scholarship':
 * @property string $student_outplacement_university_scholarship_id
 * @property string $student_outplacement_university_ref_id
 * @property string $scholarship_type
 * @property integer $scholarship_percent
 * @property integer $scholarship_amount
 * @property integer $amount_currency_ref_id
 * @property string $scholarship_provider
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LookupCurrency $amountCurrencyRef
 * @property StudentOutplacementUniversity $studentOutplacementUniversityRef
 */
class BaseStudentOutplacementUniversityScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementUniversityScholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_university_scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_outplacement_university_ref_id, added_on, added_by', 'required'),
			array('scholarship_percent, scholarship_amount, amount_currency_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_outplacement_university_ref_id, added_by', 'length', 'max'=>10),
			array('scholarship_type', 'length', 'max'=>6),
			array('scholarship_provider', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_university_scholarship_id, student_outplacement_university_ref_id, scholarship_type, scholarship_percent, scholarship_amount, amount_currency_ref_id, scholarship_provider, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'amountCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'amount_currency_ref_id'),
			'studentOutplacementUniversityRef' => array(self::BELONGS_TO, 'StudentOutplacementUniversity', 'student_outplacement_university_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_university_scholarship_id' => 'Student Outplacement University Scholarship',
			'student_outplacement_university_ref_id' => 'Student Outplacement University Ref',
			'scholarship_type' => 'Scholarship Type',
			'scholarship_percent' => 'Scholarship Percent',
			'scholarship_amount' => 'Scholarship Amount',
			'amount_currency_ref_id' => 'Amount Currency Ref',
			'scholarship_provider' => 'Scholarship Provider',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_university_scholarship_id',$this->student_outplacement_university_scholarship_id,true);
		$criteria->compare('student_outplacement_university_ref_id',$this->student_outplacement_university_ref_id,true);
		$criteria->compare('scholarship_type',$this->scholarship_type,true);
		$criteria->compare('scholarship_percent',$this->scholarship_percent);
		$criteria->compare('scholarship_amount',$this->scholarship_amount);
		$criteria->compare('amount_currency_ref_id',$this->amount_currency_ref_id);
		$criteria->compare('scholarship_provider',$this->scholarship_provider,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}