<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_department".
 *
 * The followings are the available columns in table 'student_preferred_department':
 * @property string $preferred_department_id
 * @property string $user_ref_id
 * @property integer $popular_course_ref_id
 * @property integer $popular_subdept_course_ref_id
 * @property integer $main_dept_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $added_on
 * @property integer $not_sure
 * @property integer $preference_order
 * @property string $course_ref_id
 *
 * The followings are the available model relations:
 * @property Courses $courseRef
 * @property LookupPopularCourses $popularCourseRef
 * @property LookupPopularSubdeptCourse $popularSubdeptCourseRef
 * @property LookupDepartment $mainDeptRef
 * @property LookupDepartment $subDeptRef
 * @property TblUserMaster $userRef
 */
class BaseStudentPreferredDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('popular_course_ref_id, popular_subdept_course_ref_id, main_dept_ref_id, sub_dept_ref_id, not_sure, preference_order', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, course_ref_id', 'length', 'max'=>10),
			array('preferred_department_id, added_on, not_sure,user_ref_id, popular_course_ref_id, popular_subdept_course_ref_id, main_dept_ref_id, sub_dept_ref_id,', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_department_id, user_ref_id, popular_course_ref_id, popular_subdept_course_ref_id, main_dept_ref_id, sub_dept_ref_id, added_on, not_sure, preference_order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'courseRef' => array(self::BELONGS_TO, 'Courses', 'course_ref_id'),
			'popularCourseRef' => array(self::BELONGS_TO, 'LookupPopularCourses', 'popular_course_ref_id'),
			'popularSubdeptCourseRef' => array(self::BELONGS_TO, 'LookupPopularSubdeptCourse', 'popular_subdept_course_ref_id'),
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_department_id' => 'Preferred Department',
			'user_ref_id' => 'User Ref',
			'popular_course_ref_id' => 'Popular Course Ref',
			'popular_subdept_course_ref_id' => 'Popular Subdept Course Ref',
			'main_dept_ref_id' => 'Main Dept Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'added_on' => 'Added On',
			'not_sure' => 'Not Sure',
			'preference_order' => 'Preference Order',
            'course_ref_id' => 'Course Id',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_department_id',$this->preferred_department_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('popular_course_ref_id',$this->popular_course_ref_id);
		$criteria->compare('popular_subdept_course_ref_id',$this->popular_subdept_course_ref_id);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('not_sure',$this->not_sure);
		$criteria->compare('preference_order',$this->preference_order);
        $criteria->compare('course_ref_id',$this->course_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}