<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredLocation is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_location".
 *
 * The followings are the available columns in table 'student_preferred_location':
 * @property string $preferred_location_id
 * @property string $preferred_country_ref_id
 * @property integer $city_ref_id
 * @property integer $state_ref_id
 * @property integer $region_ref_id
 * @property string $added_on
 * @property integer $cluster_ref_id
 *
 * The followings are the available model relations:
 * @property LookupCityCluster $clusterRef
 * @property TblCityMaster $cityRef
 * @property StudentPreferredCountry $preferredCountryRef
 * @property LookupRegion $regionRef
 * @property TblState $stateRef
 */
class BaseStudentPreferredLocation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_location';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('preferred_country_ref_id', 'required'),
			array('city_ref_id, state_ref_id, region_ref_id, cluster_ref_id', 'numerical', 'integerOnly'=>true),
			array('preferred_country_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_location_id, preferred_country_ref_id, city_ref_id, state_ref_id, region_ref_id, added_on, cluster_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'clusterRef' => array(self::BELONGS_TO, 'LookupCityCluster', 'cluster_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'preferredCountryRef' => array(self::BELONGS_TO, 'StudentPreferredCountry', 'preferred_country_ref_id'),
			'regionRef' => array(self::BELONGS_TO, 'LookupRegion', 'region_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_location_id' => 'Preferred Location',
			'preferred_country_ref_id' => 'Preferred Country Ref',
			'city_ref_id' => 'City Ref',
			'state_ref_id' => 'State Ref',
			'region_ref_id' => 'Region Ref',
			'added_on' => 'Added On',
			'cluster_ref_id' => 'Cluster Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_location_id',$this->preferred_location_id,true);
		$criteria->compare('preferred_country_ref_id',$this->preferred_country_ref_id,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('region_ref_id',$this->region_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('cluster_ref_id',$this->cluster_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}