<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentProfileValidationUmailLog is autogenerate by UniModel generator
 *
 * This is the model class for table "student_profile_validation_umail_log".
 *
 * The followings are the available columns in table 'student_profile_validation_umail_log':
 * @property string $profile_validation_log_id
 * @property string $user_ref_id
 * @property string $profile_validate_status
 * @property integer $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblUserMaster $userRef
 */
class BaseStudentProfileValidationUmailLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentProfileValidationUmailLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_profile_validation_umail_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by, added_on', 'required'),
			array('added_by', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>11),
			array('profile_validate_status', 'length', 'max'=>16),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('profile_validation_log_id, user_ref_id, profile_validate_status, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_validation_log_id' => 'Profile Validation Log',
			'user_ref_id' => 'User Ref',
			'profile_validate_status' => 'Profile Validate Status',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_validation_log_id',$this->profile_validation_log_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('profile_validate_status',$this->profile_validate_status,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}