<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentShortlistVendor is autogenerate by UniModel generator
 *
 * This is the model class for table "student_shortlist_vendor".
 *
 * The followings are the available columns in table 'student_shortlist_vendor':
 * @property string $student_shortlist_vendor_id
 * @property string $user_ref_id
 * @property string $vendor_centre_ref_id
 * @property integer $entrance_ref_id
 * @property string $shortlist_status
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceRef
 * @property TblUserMaster $userRef
 * @property VendorCentre $vendorCentreRef
 */
class BaseStudentShortlistVendor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentShortlistVendor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_shortlist_vendor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('entrance_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, vendor_centre_ref_id', 'length', 'max'=>10),
			array('shortlist_status', 'length', 'max'=>13),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_shortlist_vendor_id, user_ref_id, vendor_centre_ref_id, entrance_ref_id, shortlist_status, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_shortlist_vendor_id' => 'Student Shortlist Vendor',
			'user_ref_id' => 'User Ref',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'entrance_ref_id' => 'Entrance Ref',
			'shortlist_status' => 'Shortlist Status',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_shortlist_vendor_id',$this->student_shortlist_vendor_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('shortlist_status',$this->shortlist_status,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}