<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentUploadMasterNoEmail is autogenerate by UniModel generator
 *
 * This is the model class for table "student_upload_master_no_email".
 *
 * The followings are the available columns in table 'student_upload_master_no_email':
 * @property string $student_upload_master_no_email_id
 * @property integer $inst_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property string $class
 * @property string $class_status
 * @property integer $board_ref_id
 * @property string $gender
 * @property integer $completion_month
 * @property integer $completion_year
 * @property integer $profile_created
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupBoard $boardRef
 * @property TblSiDi $instRef
 * @property LoginMaster $modifiedBy
 */
class BaseStudentUploadMasterNoEmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentUploadMasterNoEmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_upload_master_no_email';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('completion_year, added_on, added_by', 'required'),
			array('inst_ref_id, board_ref_id, completion_month, completion_year, profile_created', 'numerical', 'integerOnly'=>true),
			array('first_name, last_name', 'length', 'max'=>100),
			array('class', 'length', 'max'=>2),
			array('class_status', 'length', 'max'=>8),
			array('gender', 'length', 'max'=>1),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_upload_master_no_email_id, inst_ref_id, first_name, last_name, class, class_status, board_ref_id, gender, completion_month, completion_year, profile_created, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_upload_master_no_email_id' => 'Student Upload Master No Email',
			'inst_ref_id' => 'Inst Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'class' => 'Class',
			'class_status' => 'Class Status',
			'board_ref_id' => 'Board Ref',
			'gender' => 'Gender',
			'completion_month' => 'Completion Month',
			'completion_year' => 'Completion Year',
			'profile_created' => 'Profile Created',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_upload_master_no_email_id',$this->student_upload_master_no_email_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('class_status',$this->class_status,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('completion_month',$this->completion_month);
		$criteria->compare('completion_year',$this->completion_year);
		$criteria->compare('profile_created',$this->profile_created);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}